<?php
require_once ("File.php");
require_once ("File/Util.php");
/**
 * ファイルシステム関数のショートカット
 * @author okada
 *
 */
class CFW_IO_FileSystem{
	/**
	 * ディレクトリ作成
	 *
	 * $direSpecで指定したディレクトリ定義に基づき実ディレクトリを作成し、作成したディレクトリ名を返す
	 * @param $baseDir 基準ディレクトリ 必ず存在し、書き込めなければならない
	 * @param $dirSpec 追加ディレクトリの定義 配列
	 * @return String 作成したディレクトリ名
	 */
	public static function createDirectory($baseDir,$dirSpec = array()){

		$b = split(addslashes(DS),$baseDir);
		$path = "";
		foreach($b as $bb){
            $path = File_Util::buildPath(array($path,$bb));
            if(!file_exists($path)){
                mkdir($path);
            }

		}

		foreach($dirSpec as $dir){
			$path = File_Util::buildPath(array($path,$dir));
			if(!file_exists($path)){
				mkdir($path);
			}
		}
		return $path;
	}
	/**
	 * 渡されたパスを解決する
	 *
	 * 渡されたパスが相対ディレクトリの場合BASE_DIRを基準としたパスを返す。
	 * 絶対パスの場合はそのパスをそのまま返す。
	 * パスのディレクトリが無ければ作成する。
	 * @param unknown_type $path
	 * @return unknown_type
	 */
	public static function resolvePath($path){
        if(File_Util::isAbsolute($path)){
            return $path;
        }
        else{
            $realpath = BASE_PATH.DS.$path;
            return realpath($realpath);
        }
        return BASE_PATH;
	}
}
?>