<?php
/**
 * 読み取り専用前進カーソルデータリーダー
 * @author okada
 *
 */
class CFW_Data_Reader{
    /**
     * データベースへの接続
     * @var CFW_Data_Connection
     */
	var $connection;
	/**
	 * 実行したステートメント
	 * @var PDO_Statement
	 */
	var $statement;
	/**
	 * 現在の行データ
	 * @var unknown_type
	 */
	var $current;
	/**
	 * 構築
	 * @return unknown_type
	 */
	public function __construct(){

	}
	/**
	 * カーソルを移動して現在の行を設定
	 * @return unknown_type
	 */
	public function read(){
		$this->current = $this->statement->fetch(PDO::FETCH_ASSOC);
		if(!$this->current){
		    return false;
		}
		$this->connection->decodeVariables($this->current);
		return ($this->current !== false);
	}
	/**
	 * 現在の行の列データ取得
	 * @param $field
	 * @return unknown_type
	 */
	public function get($field){
		if(array_key_exists($field,$this->current)){
			return $this->current[$field];
		}
		else{
			return null;
		}
	}

}
?>