<?php
include("../core.php");

$config = CFW_Common_Config::factory("datasource");


$source = CFW_Model_DataSource::getDataSource($config->default);
$source->connect();

$table = new CFW_Database_TableModel();
$table->_catalog = "okada";
$table->_schema = "dbo";
$table->_name= "MAST_MENU";
$table->_primaryKeys = array("SITE_CODE","MENU_CODE");


$fields =array( "SITE_CODE,COUNT(*) CNT" );
$c = new CFW_Database_Criteria();
$c->add("OPEN_DATE" ,"20080101",">=");
$c->addLimit(10);
$c->addOffset(0);
$c->addGroupBy("SITE_CODE");
$c->addOrderBy("SITE_CODE");


$result = $source->read($table,$c,$fields);

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>describe columns</title>
</head>
<body>
<div>
<?php foreach($result->rows as $row): ?>
    <?php echo $row->SITE_CODE ?>:<?php echo $row->CNT ?><br />
<?php endforeach;?>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>