<?php
/**
 * データベース接続
 * @author okada
 *
 */
abstract class CFW_Database_AbstractConnection{
    /**
     * 設定
     * @var unknown_type
     */
	var $config;
	/**
	 * 実際のPHP接続
	 * @var unknown_type
	 */
	var $_connection;
	/**
	 * カタログ
	 * @var unknown_type
	 */
	var $catalog;
	/**
	 * DBサーバー文字セット
	 * @var unknown_type
	 */
	var $serverCharset;
    /**
     * DBクライアント(つまりPHP側)
     * @var unknown_type
     */
	var $clientCharset;
	/**
	 * 構築
	 * @param $config
	 * @return unknown_type
	 */
	public function __construct($config){
	   $this->config = $config;	
       $this->catalog = $this->config->params->dbname;   
        $this->serverCharset = $this->config->params->charset;
        $this->clientCharset = mb_internal_encoding();
	}
	/**
	 * 接続
	 * @return unknown_type
	 */
	public function connect(){
		$dsn = $this->_createDSN();
		$user = $this->config->params->username; 
        $pass = $this->config->params->password;
         
		$this->_connection = new PDO($dsn,$user,$pass);
		
	}
	/**
	 * DSN文字列作成
	 * @return unknown_type
	 */
	function _createDSN(){
	   $dsn = $this->config->driver;
	   $dsn .= "host=".$this->config->params->host . ";";	
       $dsn .= "dbname=".$this->config->params->dbname . ";";   
       $dsn .= "port=".$this->config->params->port. ";";
       return $dsn;
	}
	public function disconnect(){
		$this->_connection = null;
	}
	/**
	 * トランザクション開始
	 * @return unknown_type
	 */
	public function beginTransaction(){
		$this->_connection->beginTransaction();
	}
	/**
	 * トランザクションコミット
	 * @return unknown_type
	 */
	public function commitTransaction(){
	   $this->_connection->commit();	
	}
    /**
     * トランザクションロールバック
     * @return unknown_type
     */
	public function rollbackTransaction(){
	   $this->_connection->rollBack();	
	}
	/**
	 * 文字列引用符付加処理
	 * @param $val
	 * @param $type
	 * @return unknown_type
	 */
	public abstract function quote($val,$type = CFW_Model_DataTypes::VARCHAR);

	/**
	 * サーバー側文字セットにエンコード
	 * @param $val
	 * @return unknown_type
	 */
	public function encode($val){
	    return $val;
	}
    /**
     * サーバー側文字セットからクライアント文字セットにデコード
     * @param $val
     * @return unknown_type
     */
	public function decode($val){
	    return $val;
	}
        
    /**
     * サーバー側文字セットにエンコード
     * @param $variables
     * @return unknown_type
     */
	public function encodeVariables(&$variables){
        return true;
        return mb_convert_variables($this->serverCharset,$this->clientCharset,$variables);
    }
    /**
     * サーバー側文字セットにエンコード
     * @param $variables
     * @return unknown_type
     */
    public function decodeVariables(&$variables){
        return true;
    }
    public static function getConnection($config){
        $driver = ucfirst( $config->driver );
        $className = "CFW_Database_Connection_" . $driver;
        return new $className($config);
    }
    
}
?>