<?php
Zend_Loader::loadClass("Zend_Config_Ini");
/**
 * Zend_Configのショートカットクラス
 * 
 * 定数 "ENV"が定義されているときは読み込むセクションのデフォルトに使用する。
 * そうでなければ"production"を読み込むセクションのデフォルトに使用する。
 * @author okada
 *
 */
class CFW_Common_Config{

	/**
	 * 設定オブジェクトを取得
	 * @param $name 設定種別名
	 * @param $env 環境名 指定されなければ定数"ENV"の設定を、定数"ENV"が設定されていなければ"production"をデフォルトにする
	 * @return unknown_type
	 */
	public static function factory($name = "core",$env = null){
		if(!$env){
			if(defined("ENV")){
				$env = ENV;
			}
			else{
				$env = "production";
			}
		}
		
		$config = new Zend_Config_Ini(CONFIG_DIR.'/'.$name.'.ini',$env);
		return $config;
	}
}
?>