<?php
include_once("../startup.php");
require_once 'PHPUnit/Framework.php';
require_once("CFW/Util/Date.php");

class DateUtilTest extends PHPUnit_Framework_TestCase {
	
	public function testtoDate() {
		$result = CFW_Util_Date::toDate(20091126);
		$this->assertEquals(new Date("20091126"), $result);
		
		$result = CFW_Util_Date::toDate("2009/11/26");
		$this->assertEquals(new Date("20091126"), $result);
		
		$result = CFW_Util_Date::toDate("09/11/26");
		$this->assertEquals(new Date("20091126"), $result);
		
		$result = CFW_Util_Date::toDate("  ");
		$this->assertEquals(null, $result);
		
		$result = CFW_Util_Date::toDate(new Date("20091126"));
		$this->assertEquals(new Date("20091126"), $result);
	}
	public function testtoday() {
		$result = CFW_Util_Date::today();
		$today = new Date();
		$this->assertEquals(new Date($today->getYear().$today->getMonth().$today->getDay()), $result);
	}
	
	public function testformat() {
		$dateTime = new Date("20090101");
		
		$result = CFW_Util_Date::format($dateTime);
		$this->assertEquals("2009/01/01 00:00:00", $result);
		
		$result = CFW_Util_Date::format($dateTime, "%Y/%m");
		$this->assertEquals("2009/01", $result);
		
		$result = CFW_Util_Date::format($dateTime, "%m/%d");
		$this->assertEquals("01/01", $result);
		
		$result = CFW_Util_Date::format(null);
		$this->assertEquals("", $result);
		
		$dateTime = new Date("20090101123456");
		
		$result = CFW_Util_Date::format($dateTime);
		$this->assertEquals("2009/01/01 12:34:56", $result);
		
		$result = CFW_Util_Date::format($dateTime, "%H:%M");
		$this->assertEquals("12:34", $result);
	}
	
	public function testcreate() {
		$result = CFW_Util_Date::create(2009,1,1);
		$dateTime = new Date("20090101");
		$this->assertEquals($dateTime, $result);
		
		$result = CFW_Util_Date::create(9,1,1);
		$dateTime = new Date("00090101");
		$this->assertEquals($dateTime, $result);
	}
	public function testcreateFromYearMonth() {
		$result = CFW_Util_Date::createFromYearMonth(2009, 3);
		$testDate = new Date("20090301");
		$this->assertEquals($testDate, $result);
		
		$result = CFW_Util_Date::createFromYearMonth("", 3);
		$testDate = new Date("00000301");
		$this->assertEquals($testDate, $result);
		
		$result = CFW_Util_Date::createFromYearMonth("", "");
		$testDate = new Date("00000001");
		$this->assertEquals($testDate, $result);
	}
	public function testdiffDays() {
		$result = CFW_Util_Date::diffDays("20090102","20090101");
		$this->assertEquals(-1, $result);
		
		$result = CFW_Util_Date::diffDays("20090203","20090304");
		$this->assertEquals(29, $result);
	}
	
	public function testageYear() {
		$result = CFW_Util_Date::ageYear("20000101","20010101");
		$this->assertEquals(1, $result);
		
		$result = CFW_Util_Date::ageYear("19830710","20091126");
		$this->assertEquals(26, $result);
	}
	public function testageMonth() {
		$result = CFW_Util_Date::ageMonth("20000101","20010101");
		$this->assertEquals(12, $result);
		
		$result = CFW_Util_Date::ageMonth("19830710","20091126");
		$this->assertEquals(316, $result);
	}
	public function testageString() {
		$result = CFW_Util_Date::ageString("19830710","20091126");
		$this->assertEquals("26Y", $result);
		
		$birthDay = new Date("20000101");
		$baseDate = new Date("20091126");
		$result = CFW_Util_Date::ageString($birthDay, $baseDate);
		$this->assertEquals("9Y", $result);
		
		$birthDay = new Date("20090101");
		$baseDate = new Date("20091126");
		$result = CFW_Util_Date::ageString($birthDay, $baseDate);
		$this->assertEquals("10M", $result);
	}
	public function testageStringJP() {
		$result = CFW_Util_Date::ageStringJP("19830710", "20091126");
		$this->assertEquals("26歳", $result);
		
		$birthDay = new Date("20000101");
		$baseDate = new Date("20091126");
		$result = CFW_Util_Date::ageStringJP($birthDay, $baseDate);
		$this->assertEquals("9歳", $result);
		
		$birthDay = new Date("20090101");
		$baseDate = new Date("20091126");
		$result = CFW_Util_Date::ageStringJP($birthDay, $baseDate);
		$this->assertEquals("10ヶ月", $result);
	}
	
	public function testdayOfWeekIndex() {
		
		$sunday = new Date("20091122");
		$monday = new Date("20091123");
		$friday = new Date("20091127");
		
		$result = CFW_Util_Date::dayOfWeekIndex(null);
		$this->assertEquals(-1, $result);
		
		$result = CFW_Util_Date::dayOfWeekIndex($sunday);
		$this->assertEquals(0, $result);
		
		$result = CFW_Util_Date::dayOfWeekIndex($monday);
		$this->assertEquals(1, $result);
		
		$result = CFW_Util_Date::dayOfWeekIndex($friday);
		$this->assertEquals(5, $result);
	}
	public function testdayOfWeekString() {
		$sunday = new Date("20091122");
		$monday = new Date("20091123");
		$friday = new Date("20091127");
		
		$result = CFW_Util_Date::dayOfWeekString($sunday);
		$this->assertEquals("SUN", $result);
		
		$result = CFW_Util_Date::dayOfWeekString($monday);
		$this->assertEquals("MON", $result);
		
		CFW_Util_Date::$UseUpperCase = false;
		$result = CFW_Util_Date::dayOfWeekString($friday);
		$this->assertEquals("Fri", $result);
	}
	public function testdayOfWeekStringJP() {
		$sunday = new Date("20091122");
		$monday = new Date("20091123");
		$friday = new Date("20091127");
		
		$result = CFW_Util_Date::dayOfWeekStringJP($sunday);
		$this->assertEquals("日", $result);
		
		$result = CFW_Util_Date::dayOfWeekStringJP($friday);
		$this->assertEquals("金", $result);
	}
	
	public function testisBefore() {
		$d1 = new Date("20091122");
		$d2 = new Date("20091123");
		
		$result = CFW_Util_Date::isBefore($d1, $d2);
		$this->assertEquals(true, $result);
		
		$result = CFW_Util_Date::isBefore($d2, $d1);
		$this->assertEquals(false, $result);
	}
	public function testisBeforeOrSame() {
		$d1 = new Date("20091122");
		$d2 = new Date("20091123");
		
		$result = CFW_Util_Date::isBeforeOrSame($d1, $d2);
		$this->assertEquals(true, $result);
		
		$result = CFW_Util_Date::isBeforeOrSame($d2, $d1);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isBeforeOrSame($d1, $d1);
		$this->assertEquals(true, $result);
	}
	public function testisAfter() {
		$d1 = new Date("20091122");
		$d2 = new Date("20091123");
		
		$result = CFW_Util_Date::isAfter($d1, $d2);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isAfter($d2, $d1);
		$this->assertEquals(true, $result);
		
		$result = CFW_Util_Date::isAfter($d1, $d1);
		$this->assertEquals(false, $result);
	}
	public function testisAfterOrSame() {
		$d1 = new Date("20091122");
		$d2 = new Date("20091123");
		
		$result = CFW_Util_Date::isAfterOrSame($d1, $d2);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isAfterOrSame($d2, $d1);
		$this->assertEquals(true, $result);
		
		$result = CFW_Util_Date::isAfterOrSame($d1, $d1);
		$this->assertEquals(true, $result);
	}
	public function testisSame() {
		$d1 = new Date("20091122");
		$d2 = new Date("20091123");
		
		$result = CFW_Util_Date::isSame($d1, $d2);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isSame($d2, $d1);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isSame($d1, $d1);
		$this->assertEquals(true, $result);
	}
	
	public function testaddDate() {
		$testDate = new Date("20090228");
		
		$result = CFW_Util_Date::addDate($testDate, 3, "Y");
		$this->assertEquals(new Date("20120228"), $result);
		
		$result = CFW_Util_Date::addDate($testDate, 2, "M");
		$this->assertEquals(new Date("20090428"), $result);
		
		$result = CFW_Util_Date::addDate($testDate, 2, "D");
		$this->assertEquals(new Date("20090302"), $result);
	}
	public function testmonthAfter() {
		$result = CFW_Util_Date::monthAfter(2009, 1, 10);
		$this->assertEquals(new Date("20091101"), $result);
		
		$result = CFW_Util_Date::monthAfter(2009, 11, -10);
		$this->assertEquals(new Date("20090101"), $result);
	}
	public function testendOfMonthAfter() {
		$result = CFW_Util_Date::endOfMonthAfter(2009,1,10);
		$this->assertEquals(new Date("20091130"), $result);
		
		$result = CFW_Util_Date::endOfMonthAfter(2012, 1, 1);
		$this->assertEquals(new Date("20120229"), $result);
	}
	public function testendOfMonth() {
		$d1 = new Date("20091127");
		$d2 = new Date("20120201");
		
		$result = CFW_Util_Date::endOfMonth($d1);
		$this->assertEquals(new Date("20091130"), $result);
		
		$result = CFW_Util_Date::endOfMonth($d2);
		$this->assertEquals(new Date("20120229"), $result);
	}
	public function testendOfYearMonth() {
		$result = CFW_Util_Date::endOfYearMonth(2009, 11);
		$this->assertEquals(new Date("20091130"), $result);
		
		$result = CFW_Util_Date::endOfYearMonth(2012, 2);
		$this->assertEquals(new Date("20120229"), $result);
	}
	public function testisEndOfMonth() {
		$d1 = new Date("20091130");
		$d2 = new Date("20091115");
		$d3 = new Date("20120229");
		
		$result = CFW_Util_Date::isEndOfMonth($d1);
		$this->assertEquals(true, $result);
		
		$result = CFW_Util_Date::isEndOfMonth($d2);
		$this->assertEquals(false, $result);
		
		$result = CFW_Util_Date::isEndOfMonth($d3);
		$this->assertEquals(true, $result);
	}
	public function testnextMonth() {
		$result = CFW_Util_Date::nextMonth(2009, 11);
		$this->assertEquals(new Date("20091201"), $result);
	}
	public function testpreviousMonth() {
		$result = CFW_Util_Date::previousMonth(2009, 11);
		$this->assertEquals(new Date("20091001"), $result);
	}
}
