<?php
/**
 * スタック
 * @author okada
 *
 */
class CFW_Util_Stack{
    /**
     * スタックポインタ
     * @var unknown_type
     */
    var $sp;
    /**
     * スタックデータ
     * @var unknown_type
     */
    var $arr;
    /**
     * 構築
     * @return unknown_type
     */
    public function __construct(){
        $this->sp = 0;
        $this->arr = array();
    }
    /**
     * スタックデータへのプッシュ
     * @param $val
     * @return unknown_type
     */
    public function push($val){
        array_push( $this->arr,$val);
        $this->sp++;   
    }
    /**
     * スタックデータからのポップ
     * @return unknown_type
     */
    public function pop(){
        $this->sp--;
        return array_pop($this->arr);
    }
    /**
     * スタックデータから指定位置の要素を取得
     * @param $p
     * @return unknown_type
     */
    public function element($p){
        if($p < 0) return null;
        if($p > $this->sp) return null;
        
        return $this->arr[$p];
    }
    /**
     * 最後の要素取得
     * @return unknown_type
     */
    public function last(){
        return $this->arr[$this->sp];
    }
    /**
     * 現在のスタックポインターを取得
     * @return unknown_type
     */
    public function pointer(){
        return $this->sp;
    }
    /**
     * ダンプ
     * @return unknown_type
     */
    public function dump(){
        foreach($this->arr as $el){
            echo $el . " ";
        }
        echo "<br />";
    }
}

?>