<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_IO_FileSystem");
Zend_Loader::loadClass("CFW_MessageResource_Default");
/**
 * メッセージリソース生成クラス
 * @author okada
 *
 */
class CFW_MessageResource_Factory{
    /**
     * 指定名称のリソースを取得する
     * @param array $names 名称を配列で指定
     * @return CFW_MessageRresource_Default
     */
    public static function getResource(Array $names){
        $config = CFW_Config_Configuration::getInstance("core");
        $messageResourcePath = CFW_IO_FileSystem::resolvePath($config->messageResource->path);
        $resouce = null;
        $length = count($names);
        for($i = $length;$i > 0;$i--){
            $fullName = self::buildFileName($messageResourcePath,$names,$i);
            if(file_exists($fullName)){
                $resource = new CFW_MessageResource_Default();
                $resource->load($fullName);
                break;
            }
        }
        return $resource;
    }
    /**
     * 指定パス、指定名称から本当のファイル名を組み立てる
     * @param unknown_type $path
     * @param unknown_type $names
     * @param unknown_type $depth
     * @return unknown_type
     */
    static function buildFileName($path,$names,$depth){
        $p = "";
        for($i = 0; $i < $depth ; $i++){
            if($i > 0) $p .= ".";
            $p .= $names[$i];
        }
        $fullName =  File_Util::buildPath(array($path,$p)) . ".txt";
        return $fullName;
    }

}