<?php
Zend_Loader::loadClass("CFW_Auth_ProviderFactory");
Zend_Loader::loadClass("CFW_Log_Level");

class CFW_Log_Logger{


	/**
	 * モジュール名称
	 * @var string
	 */
	public $moduleName;
	/**
	 * ログレベル
	 * @var integer
	 */
	public $logLevel;
	/**
	 * writer本体
	 * @var unknown_type
	 */
	public $writer;

	/**
	 * 緊急事態
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function emergency($methodName, $message, $userId = null) {
		if ($userId == null) {
			$userId = $this->getUserId();
		}
		if ($this->logLevel >= CFW_Log_Level::EMERGENCY) {
			$this->writer->write(CFW_Log_Level::EMERGENCY, $userId, $this->$moduleName, $methodName, $message);
		}
	}
	/**
	 * 警報
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function alert($methodName, $message, $userId = null) {
		if ($userId == null) {
			$userId = $this->getUserId();
		}
		if ($this->logLevel >= CFW_Log_Level::ALERT) {
			$this->writer->write(CFW_Log_Level::ALERT, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 危機
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function critical($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		}
		if ($this->logLevel >= CFW_Log_Level::CRITICAL) {
			$this->writer->write(CFW_Log_Level::CRITICAL, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * エラー
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function error($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		}
		if ($this->logLevel >= CFW_Log_Level::ERROR) {
			$this->writer->write(CFW_Log_Level::ERROR, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 警告
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function warning($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		}
		if ($this->logLevel >= CFW_Log_Level::WARNING) {
			$this->writer->write(CFW_Log_Level::WARNING, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 注意
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function notice($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		    		}
		if ($this->logLevel >= CFW_Log_Level::NOTICE) {
			$this->writer->write(CFW_Log_Level::NOTICE, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 情報
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function info($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		    		}
		if ($this->logLevel >= CFW_Log_Level::INFO) {
			$this->writer->write(CFW_Log_Level::INFO, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * デバック
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $userId 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function debug($methodName, $message, $userId = null) {
		if ($userId == null) {
            $userId = $this->getUserId();
		    		}
		if ($this->logLevel >= CFW_Log_Level::DEBUG) {
			$this->writer->write(CFW_Log_Level::DEBUG, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 現在のユーザーID
	 * @param $userId
	 * @return unknown_type
	 */
	function getUserId() {
	    $provider = CFW_Auth_ProviderFactory::getProvider();
	    if($provider->isAuthenticated()){
	      $id = $provider->getIdentity();
	      return $id->name;
	    }
		return "";
	}
}