<?php
Zend_Loader::loadClass("Zend_Log");
Zend_Loader::loadClass("CFW_Log_Log");
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_DataSource");
Zend_Loader::loadClass("CFW_Util_Dump");
Zend_Loader::loadClass("CFW_Data_Amf_CriteriaParser");
/**
 * AMF呼び出し専用のデータソース
 * @remarks 各メソッド内で一回限りの接続を使用し、連携は不可。
 * 連携させる部分はメソッドを別にする
 * @author okada
 *
 */
class CFW_Data_Amf_DataSource{
    var $connection;
    var $datasource;
    var $entityProperty;
    var $logger;
    public function __construct(){
    	$this->logger = CFW_Log_Log::factory();
    }
    function open($name){
    	$this->connection = CFW_Data_ConnectionFactory::getConnection($name);
    	$this->connection->connect();
    	$this->datasource = new CFW_Data_DataSource(null);
    	$this->datasource->setConnection($this->connection);


    }
    function close(){
        $this->connection->disconnect();
        $this->datasource = null;
        $this->connection = null;
    }
    /**
     * @param unknown_type $name
     * @param unknown_type $table
     * @param unknown_type $data
     * @param unknown_type $fields
     * @return unknown
     */
    public function saveData($name,$table,$data,$fields = array()){
        $this->logger->log(__FUNCTION__,Zend_Log::INFO);

        $this->logger->log(CFW_Util_Dump::dump( $data ),Zend_Log::INFO);

        $this->open($name);

        $this->datasource->tableName = $table;
        $result = $this->datasource->save($data,$fields);
        $this->connection = null;
        return $result;
    }
    /**
     * @param unknown_type $name
     * @param unknown_type $table
     * @param unknown_type $data
     * @param unknown_type $fields
     * @return unknown_type
     */
    public function insertData($name,$table,$data,$fields = array()){
        $this->logger->log("insert start",Zend_Log::INFO);
    	$this->logger->log(CFW_Util_Dump::dump( $data ),Zend_Log::INFO);

        $this->open($name);
        $this->datasource->tableName = $table;
        $result = $this->datasource->insert($data,$fields);

        $this->logger->log("insert end",Zend_Log::INFO);
        return $result;
    }
    /**
     * @param unknown_type $name
     * @param unknown_type $table
     * @param unknown_type $data
     * @param unknown_type $criteria
     * @param unknown_type $fields
     * @return unknown_type
     */
    public function updateData($name,$table,$data,$criteria,$fields = array()){
        $this->logger->log(CFW_Util_Dump::dump( $data ),Zend_Log::INFO);
        $this->logger->log(CFW_Util_Dump::dump( $criteria ),Zend_Log::INFO);
        $parser = new CFW_Data_Amf_CriteriaParser();
        $c = $parser->parse($criteria);
        $this->open($name);
        $this->datasource->tableName = $table;
        return $this->datasource->update($data,$c,$fields);

    }
    /**
     * @param unknown_type $name
     * @param unknown_type $table
     * @param unknown_type $criteria
     * @param unknown_type $fields
     * @return unknown_type
     */
    public function deleteData($name,$table,$criteria,$fields = array()){
        $this->logger->log(CFW_Util_Dump::dump( $criteria ),Zend_Log::INFO);

        $parser = new CFW_Data_Amf_CriteriaParser();
        $c = $parser->parse($criteria);
        $this->open($name);
        $this->datasource->tableName = $table;
        return $this->datasource->delete($c,$fields);

    }
    /**
     * @param unknown_type $name
     * @param unknown_type $table
     * @param unknown_type $criteria
     * @param unknown_type $fields
     * @return unknown_type
     */
    public function findData($name,$table,$criteria,$fields = array()){
        $this->logger->log(CFW_Util_Dump::dump( $criteria ),Zend_Log::INFO);

        $parser = new CFW_Data_Amf_CriteriaParser();
        $c = $parser->parse($criteria);
        $this->open($name);
        $this->datasource->tableName = $table;
        return $this->datasource->find($c,$fields);

    }
}