<?php
/**
 * 2次元データをあらわすエンティティ 
 * @author okada
 *
 */
class CFW_Model_DataTable extends CFW_Model_Entity{
    /**
     * DataRowの配列
     * @var array
     */
    var $rows;
    /**
     * $rowsに保持する行のクラス名
     * @var String
     */
    var $_rowType = "CFW_Model_DataRow";
    /**
     * 構築
     * @return unknown_type
     */
    public function __construct(){
        $this->rows = array();
    }
    /**
     * このエンティティが保持できる行のインスタンスを作成
     * @return CFW_Data_DataRow またはCFW_Data_DataRowのサブクラス
     */
    public function newRow(){
        $class = $this->_rowType;
        return new $class();
    }
    /**
     * 行数を取得
     * @return int
     */
    public function rowCount(){
        return count( $this->rows );
    }
    
}
?>