<?php
/**
 * Mysql用データソース
 * @author okada
 *
 */
class CFW_Database_DataSource_Mysql extends CFW_Database_AbstractDataSource{
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractDataSource#getLastId()
     */
    public function getLastId(){
        return $this->connection->lastInsertId();
    }

    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractDataSource#_buildFullName($model)
     */
    function _buildFullName(&$model){
        $fn = "";
        if( !empty($model->_schema)) $fn .= $model->_schema. "."; 
        if( !empty($model->_name)) $fn .= $model->_name; 
        
        return $fn;
    }
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractDataSource#describe()
     */
    public function describe(&$model){
        $config = CFW_Common_Config::factory("core");
        $cache = CFW_Common_Cache::factory($config->datasource->toArray());
        $cacheKey = str_replace(".","__",$this->_buildFullName($model));
        $cols = $cache->load($cacheKey);
        if($cols){
            return $cols;
        }

        
        $cols = array();
        $q = "select * 
        from information_schema.columns
where table_schema = :schema and table_name = :tableName order by ordinal_position";
        $command = new CFW_Database_Command($q);
        $command->setConnection($this->connection);
        $command->addParameter(":schema",$model->_schema);
        $command->addParameter(":tableName",$model->_name);
        $reader = $command->executeReader();
        while($reader->read()){
            $col = new CFW_Model_DataColumn();
            $col->schema = $reader->get("TABLE_SCHEMA");
            $col->tableName = $reader->get("TABLE_NAME");
            $col->name = $reader->get("COLUMN_NAME");
            $col->default = $reader->get("COLUMN_DEFAULT");
            $col->nullable =  ($reader->get("IS_NULLABLE") == "YES" ? true : false);
            $col->type = $reader->get("DATA_TYPE");
            $col->length = $reader->get("CHARACTER_OCTET_LENGTH");
            $col->precision = $reader->get("NUMERIC_PRECISION");
            $col->scale = $reader->get("NUMERIC_SCALE");
            $columnKey = $reader->get("COLUMN_KEY");
            if($columnKey == "PRI"){
                $col->primaryKey = true;
            }
            $extra =  $reader->get("EXTRA");
            if($extra == "auto_increment"){
                $col->identity = true;
            }
            
            
            $cols[$col->name] = $col;
        }
        
       
        $cache->save($cols,$cacheKey);
        return $cols;
        
    }
    public function escapeWildCard($val){
        $str = $val;
        // 円マーク(バックスラッシュ)をLIKE用に2重化
        $str = mb_ereg_replace('\\\\','\\\\',$str);
        // LIKEで使われるワイルドカード(%)をエスケープ処理
        $str = mb_ereg_replace('%','\%',$str);
        // LIKEで使われるワイルドカード(_)をエスケープ処理
        $str = mb_ereg_replace('_','\_',$str);
        return $str;
    }
}
?>