<?php
/**
 * Zend_Logのショートカットクラス
 * 
 * core.iniのlog.*を基にしてファイルログを作成する。
 * 設定
 * log.path ログファイルを保存するパス %Y,%m,%dをそれぞれ年,月,日と置き換える。
 * log.priority ログ出力レベル。0 - 7 (0:致命的 ＞ 7:デバッグ)
 * log.base_name ログファイルの基本名 %Y,%m,%dをそれぞれ年,月,日と置き換える。
 *  
 * @author okada
 *
 */
class CFW_Common_Log{
	/**
	 * インスタンス生成
	 * @return Zend_Logのインスタンス
	 */
	public static function factory(){
		$config = CFW_Common_Config::factory("core");
		$t = time();
		$logPath = self::resolveName($config->log->path,$t);
        $baseName = self::resolveName($config->log->base_name,$t);
        
        if(File_Util::isAbsolute($logPath)){
            $path = CFW_Common_FileSystem::createDirectory($logPath);
        }
        else{
        	$logPathFragment = split(addslashes(DS),$logPath);
            $path = CFW_Common_FileSystem::createDirectory(BASE_DIR, $logPathFragment);
        }
		$path = File_Util::buildPath(array($path,$baseName));
		$writer = new Zend_Log_Writer_Stream($path);
		
		$priorityFilter = new Zend_Log_Filter_Priority(intval( $config->log->priority));
		$writer->addFilter($priorityFilter);
		
		$logger = new Zend_Log();
		$logger->addWriter($writer);
		
		return $logger;
	}
	static function resolveName($name,$date){
		$n = str_replace("%Y",date("Y",$date),$name);
        $n = str_replace("%m",date("m",$date),$n);
        $n = str_replace("%d",date("d",$date),$n);
        
        return $n;
	}
}
?>