using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

[assembly: WebResource("JScript1.js", "text/javascript", PerformSubstitution = false)]

namespace Samples.AspNet.CS.Controls
{
    [DefaultProperty("Title")]
    [ToolboxData("<{0}:YuiCalendar runat=server></{0}:YuiCalendar>")]
    public class YuiCalendar : WebControl,INamingContainer
    {
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Title
        {
            get
            {
                String s = (String)ViewState["Title"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["Title"] = value;
            }
        }
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public DateTime PageDate
        {
            get
            {
                if (ViewState["PageDate"] == null)
                {
                    return DateTime.Now;
                }
                else
                {
                    return DateTime.Parse(ViewState["PageDate"].ToString());
                }
            }

            set
            {
                ViewState["PageDate"] = value;
            }
        }
        [Category("Appearance")]
        [Localizable(true)]
        public List<DateTime> Selected
        {
            get
            {
                if (ViewState["Selected"] == null)
                {
                    List<DateTime>  list = new List<DateTime>();
                    ViewState["Selected"] = list;
                    return list;
                }
                else
                {
                    return (List<DateTime>)ViewState["Selected"];
                }
            }

            set
            {
                ViewState["Selected"] = value;
            }
        }
        [Category("Appearance")]
        [DefaultValue(false)]
        [Localizable(true)]
        public bool MultiSelect
        {
            get
            {
                if (ViewState["MultiSelect"] == null)
                {
                    return false;
                }
                else
                {
                    return (bool)ViewState["MultiSelect"];
                }
            }

            set
            {
                ViewState["MultiSelect"] = value;
            }
        }
        [Category("Appearance")]
        [DefaultValue(1)]
        [Localizable(true)]
        public int Pages
        {
            get
            {
                if (ViewState["Pages"] == null)
                {
                    return 1;
                }
                else
                {
                    return (int)ViewState["Pages"];
                }
            }

            set
            {
                ViewState["Pages"] = value;
            }
        }
        protected override void CreateChildControls()
        {
            Controls.Clear();

            HiddenField SelectedDates = new HiddenField();
            SelectedDates.ID = "SelectedDates";
            SelectedDates.Value = BuildSelectedDateString();
            this.Controls.Add(SelectedDates);

            Panel container = new Panel();
            container.ID = "Container";
            this.Controls.Add(container);


            //base.CreateChildControls();
        }
        public override void RenderControl(HtmlTextWriter writer)
        {

            base.RenderControl(writer);
            string initstring = "";
            initstring = @"var {0} = new YuiCalendar(""{1}"",{2});{0}.render();{0}.controlId = ""{0}"";";

            this.Page.ClientScript.RegisterStartupScript(typeof(YuiCalendar), this.ClientID + "init", string.Format(initstring, this.ClientID, this.ClientID + "_Container", BuildConfiguration()), true);



        }
        protected virtual string BuildConfiguration()
        {
            StringWriter writer = new StringWriter();
            BuildConfigurationElements(writer);

            return "{" + writer.ToString() + "}";
        }
        protected virtual void BuildConfigurationElements(System.IO.StringWriter writer)
        {
            writer.Write("pagedate:\"" + this.PageDate.ToString("MM/yyyy") + "\"");
            if (this.MultiSelect) writer.Write(",MULTI_SELECT:true");
            if (this.Selected.Count > 0)
            {
                writer.Write(",selected:\"" + BuildSelectedDateString() + "\"");

            }
            writer.Write(",PAGES:" + this.Pages.ToString("#0") + "");
        }
        protected virtual string BuildSelectedDateString(){
            string sel = "";
            for (int i = 0; i < this.Selected.Count; i++)
            {
                if (sel.Length > 0) sel += ",";
                sel += this.Selected[i].ToString("MM/dd/yyyy");
            }
            return sel;
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            ScriptManager sm = ScriptManager.GetCurrent(this.Page);
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/utilities/utilities.js"));
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/container/container.js"));
            sm.Scripts.Add(new ScriptReference("~/javascript/yui-2.6.0/calendar/calendar.js"));
            sm.Scripts.Add(new ScriptReference(this.Page.ClientScript.GetWebResourceUrl(typeof(YuiCalendar), "SampleControl.JScript1.js")));

            if (Page.IsPostBack)
            {
                SetSelectedDates();
            }

        }
        void SetSelectedDates()
        {
            this.Selected.Clear();
            string selected = Page.Request.Form[this.ID + "$SelectedDates"];
            string[] dateSplit = selected.Split(new char[] { ',' });
            for (int i = 0; i < dateSplit.Length; i++)
            {
                DateTime d;
                if (DateTime.TryParse(dateSplit[i], out d))
                {
                    this.Selected.Add(d);
                }
            }
        }
        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Span;
            }
        }

    }
}
