using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.Database;
using CFW.Database.TableCommand;

using CFW.Sample;
using CFW.Sample.Test2.Model;
using CFW.Sample.Test2.Model.Base;


namespace TableModelTest.Test2
{
    [TestFixture]
    public class TableAccessTest
    {
        [NUnit.Framework.Test]
        public void Get()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();
            
            TestTable3TableAccess access = new TestTable3TableAccess(con);


            TestTable3TableRow table = new TestTable3TableRow();
            table.Field1 = 1;

            TestTable3TableRow result = access.Get(table);


            Assert.AreEqual(1, result.Field1);
            Assert.AreEqual("aaaa", result.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), result.Field3);
            Assert.AreEqual(102.34M, result.Field4);
            Assert.AreEqual(10, result.Field5);
            Assert.AreEqual(100, result.Field6Sub1);
            Assert.AreEqual(1000, result.Field6Sub2);


            con.Close();
        }
        [NUnit.Framework.Test]
        public void GetEntity()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            TableAccess<TestTable3Entity, TestTable3Property> access =
                new TableAccess<TestTable3Entity, TestTable3Property>(con);


            TestTable3Entity table = new TestTable3Entity();
            table.Field1 = 1;

            TestTable3Entity result = access.Get(table);


            Assert.AreEqual(1, result.Field1);
            Assert.AreEqual("aaaa", result.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), result.Field3);
            Assert.AreEqual(102.34M, result.Field4);
            Assert.AreEqual(10, result.Field5);
            Assert.AreEqual(100, result.Field6Sub1);
            Assert.AreEqual(1000, result.Field6Sub2);


            con.Close();
        }
        [NUnit.Framework.Test]
        public void Update()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);
            TestTable3TableAccess access = new TestTable3TableAccess(con);

            TestTable3TableRow original = new TestTable3TableRow();
            original.Field1 = 101;
            original.Field2 = "1234567890";
            original.Field3 = new DateTime(1970, 2, 3);
            original.Field4 = 123.45M;
            original.Field5 = 101;
            original.Field6Sub1 = 10100;
            original.Field6Sub2 = 101000;


            con.Open();

            int result = access.Insert(original);
            Assert.Greater(result, 0);

            con.Close();

            con.Open();
            List<TestTable3TableRow> testList = get(con, 101);

            Assert.AreEqual(1, testList.Count);
            TestTable3TableRow row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(123.45M, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10100, row.Field6Sub1);
            Assert.AreEqual(101000, row.Field6Sub2);
            con.Close();


            con.Open();

            original.Field6Sub1 =  10111;
            original.Field6Sub2 = 101111;

            result = access.Update(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();

            testList = get(con,original.Field1);

            Assert.AreEqual(1, testList.Count);
            row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(123.45M, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10111, row.Field6Sub1);
            Assert.AreEqual(101111, row.Field6Sub2);
            con.Close();

            con.Open();


            result = access.Delete(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();
            testList = get(con,original.Field1);

            Assert.AreEqual(0, testList.Count);

            con.Close();
            TestTable3TableRow clone = (TestTable3TableRow)original.Clone();


            Assert.AreEqual(101, clone.Field1);
            Assert.AreEqual("1234567890", clone.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), clone.Field3);
            Assert.AreEqual(123.45M, clone.Field4);
            Assert.AreEqual(101, clone.Field5);
            Assert.AreEqual(10111, clone.Field6Sub1);
            Assert.AreEqual(101111, clone.Field6Sub2);

            TestTable3Entity entity = new TestTable3Entity();
            entity.CopyFrom(original);
            TestTable3Entity entityClone = (TestTable3Entity)entity.Clone();

            Assert.AreEqual(101, entityClone.Field1);
            Assert.AreEqual("1234567890", entityClone.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), entityClone.Field3);
            Assert.AreEqual(123.45M, entityClone.Field4);
            Assert.AreEqual(101, entityClone.Field5);
            Assert.AreEqual(10111, entityClone.Field6Sub1);
            Assert.AreEqual(101111, entityClone.Field6Sub2);

            TestTable3TableRow baseTable = entity as  TestTable3TableRow;
            TestTable3TableRow baseClone = baseTable.Clone() as TestTable3TableRow;

            Assert.IsInstanceOfType(typeof(TestTable3Entity), baseClone);

            entityClone = baseClone as TestTable3Entity;
            Assert.IsNotNull(entityClone);
            Assert.AreEqual(101, entityClone.Field1);
            Assert.AreEqual("1234567890", entityClone.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), entityClone.Field3);
            Assert.AreEqual(123.45M, entityClone.Field4);
            Assert.AreEqual(101, entityClone.Field5);
            Assert.AreEqual(10111, entityClone.Field6Sub1);
            Assert.AreEqual(101111, entityClone.Field6Sub2);

            //Assert.AreEqual("clone hello", entityClone.Name);
        }
        List<TestTable3TableRow> get(CFW.Database.Connection con, int f1)
        {
            TestTable3TableAccess access = new TestTable3TableAccess(con);

            TestTable3TableProperty p = new TestTable3TableProperty();
            ColumnValueCondition condi = new ColumnValueCondition(p.Field1, f1, "=");
            List<TestTable3TableRow> testList = access.GetList(condi, null);

            return testList;

        }
        [NUnit.Framework.Test]
        public void GetPerf2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            TestTable3TableAccess access = new TestTable3TableAccess(con);


            TestTable3TableRow table = new TestTable3TableRow();
            table.Field1 = 1;

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            for (int i = 0; i < 1000; i++)
            {
                TestTable3TableRow result = access.Get(table);
                Assert.AreEqual(1, result.Field1);
            }
            sw.Stop();
            System.Diagnostics.Trace.WriteLine(System.Reflection.MethodBase.GetCurrentMethod().Name + " ellapsed " + sw.ElapsedMilliseconds.ToString());
            con.Close();
        }
        [NUnit.Framework.Test]
        public void GetPerf()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Sample.Model.TableAccess.TestTable3TableAccess access = new CFW.Sample.Model.TableAccess.TestTable3TableAccess(con);


            CFW.Sample.Model.TableRow.TestTable3TableRow table = new CFW.Sample.Model.TableRow.TestTable3TableRow();
            table.Field1 = 1;

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            for (int i = 0; i < 1000; i++)
            {
                CFW.Sample.Model.TableRow.TestTable3TableRow result = access.Get(table);
                Assert.AreEqual(1, result.Field1);
            }
            sw.Stop();
            System.Diagnostics.Trace.WriteLine(System.Reflection.MethodBase.GetCurrentMethod().Name + " ellapsed " + sw.ElapsedMilliseconds.ToString());
            con.Close();
        }

    }
}
