using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.Database;
using CFW.Database.TableCommand;

using CFW.Sample;
using CFW.Sample.Test3;
using CFW.Sample.Test3.Entity;
using CFW.Sample.Test3.Access;
using CFW.Sample.Test3.Property;
using CFW.Sample.Test3.Validator;
using CFW.Sample.Test3.TableAccess;
using CFW.Sample.Test3.TableFormAdapter;
using CFW.Sample.Test3.TableProperty;
using CFW.Sample.Test3.TableRow;
using CFW.Sample.Test3.TableValidator;


namespace CFW.Sample.Test
{
    [TestFixture]
    public class TableAccessTest2
    {
        [NUnit.Framework.Test]
        public void Get()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();
            
            TestTable1TableAccess access = new TestTable1TableAccess(con);


            TestTable1TableRow table = new TestTable1TableRow();
            table.Field1 = "1";
            table.Field2 = "11";

            TestTable1TableRow result = access.Get(table);


            Assert.AreEqual("1", result.Field1);
            Assert.AreEqual("11", result.Field2);
            Assert.AreEqual("testtest", result.Field3);
            Assert.AreEqual(0, result.Field4);
            Assert.AreEqual(12345M, result.Field5);

            con.Close();
        }
        [NUnit.Framework.Test]
        public void Update()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);
            TestTable1TableAccess access = new TestTable1TableAccess(con);

            TestTable1TableRow original = new TestTable1TableRow();
            original.Field1 = "a001";
            original.Field2 = "a00001";
            original.Field3 = "test001";
            original.Field4 = 101;
            original.Field5 = 123.45M;
 

            con.Open();

            int result = access.Insert(original);
            Assert.Greater(result, 0);

            con.Close();

            con.Open();
            List<TestTable1TableRow> testList = get(con, original.Field1, original.Field2);

            Assert.AreEqual(1, testList.Count);
            TestTable1TableRow row = testList[0];

            Assert.AreEqual("a001", row.Field1);
            Assert.AreEqual("a00001", row.Field2);
            Assert.AreEqual("test001", row.Field3);
            Assert.AreEqual(101, row.Field4);
            Assert.AreEqual(123.45M, row.Field5);
            con.Close();


            con.Open();

            original.Field5 =  9999999999.9999M;
            original.Field4= 101111;

            result = access.Update(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();

            testList = get(con,original.Field1,original.Field2);

            Assert.AreEqual(1, testList.Count);
            row = testList[0];

            Assert.AreEqual("a001", row.Field1);
            Assert.AreEqual("a00001", row.Field2);
            Assert.AreEqual("test001", row.Field3);
            Assert.AreEqual(101111, row.Field4);
            Assert.AreEqual(9999999999.9999M, row.Field5);
            con.Close();

            con.Open();


            result = access.Delete(original);
            Assert.Greater(result, 0);

            con.Close();


            con.Open();
            testList = get(con, original.Field1, original.Field2);

            Assert.AreEqual(0, testList.Count);

            con.Close();
        }
        List<TestTable1TableRow> get(CFW.Database.Connection con, string f1,string f2)
        {
            try
            {
                TestTable1TableAccess access = new TestTable1TableAccess(con);

                TestTable1TableProperty p = new TestTable1TableProperty();
                ComplexCondition cond = new ComplexCondition();
                cond.AddCondition(new ColumnValueCondition(p.Field1, f1, "="));
                cond.AddCondition("AND", new ColumnValueCondition(p.Field2, f2, "="));
                List<TableCommandColumn> orderColumns = new List<TableCommandColumn>();
                orderColumns.Add(new TableCommandColumn(p.Field1));
                orderColumns.Add(new TableCommandColumn(p.Field2));

                List<TestTable1TableRow> testList = access.GetList(cond, orderColumns);

                return testList;
            }
            catch (Exception ex)
            {
                ErrorHandler.ErrorMessageBuilder b = ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                b.WriteLog();
            }
            return null;

        }

    }
}
