using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using NUnit.Framework;
using CFW.Database;
using CFW.Database.TableCommand;

using CFW.Sample;
using CFW.Sample.Model;
using CFW.Sample.Model.StoredProcedureCommand;
using CFW.Sample.Model.StoredProcedureParameter;
using CFW.Sample.Model.StoredProcedureProperty;

namespace TableModelTest
{
    [TestFixture]
    public class StoredProcedureCommandTest
    {
        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;


        [NUnit.Framework.SetUp]
        public void SetUp()
        {
            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
            con.Open();
        }
        [NUnit.Framework.TearDown]
        public void ShutDown()
        {
            con.Close();
        }

        [NUnit.Framework.Test]
        public void Get()
        {


            PagedresultsNewParameter parameter = new PagedresultsNewParameter();
            parameter.Startrowindex = 1;
            parameter.Maximumrows = 10;



            CFW.Sample.Model.StoredProcedureCommand.PagedresultsNewCommand command = new PagedresultsNewCommand(con);

            DataSet result = command.ExecuteQuery(parameter);


            DataRowCollection rows = result.Tables[0].Rows;

            Assert.AreEqual(10, rows.Count);

            DataRow row = rows[0];
            Assert.AreEqual("S0001", row["SITE_CODE"]);
            Assert.AreEqual("M006", row["MENU_CODE"]);
            Assert.AreEqual(11, row["SORT_SEQ"]);

        }
        [NUnit.Framework.Test]
        public void Update()
        {


            TestUpdateParameter parameter = new TestUpdateParameter();
            parameter.F3 = "testtest";



            TestUpdateCommand command = new TestUpdateCommand(con);

            int  result = command.ExecuteUpdate(parameter);



            Assert.AreEqual(1, result);


        }

    }
}
