using System;
using System.Collections.Generic;
using System.Text;
using CFW.FieldProperties;
using CFW.Validators;
using NUnit.Framework;

namespace TableModelTest
{
    [TestFixture]
    public class ShortFieldValidatorTest
    {
        [NUnit.Framework.Test]
        public void GetValidatorTest()
        {
            FieldProperty Year = FieldProperty.NewInstance("smallint", "MST_TOUR_PLAN_MONEY_CONDITION", "YEAR", "Nx", 2, 5, 0, false, 0, true);
            Assert.IsInstanceOfType(typeof(ShortFieldProperty), Year);
            ((ShortFieldProperty)Year).MaxValue = 9999;

            FieldValidator validator = FieldValidator.GetInstance(Year);
            Assert.IsInstanceOfType(typeof(ShortFieldValidator), validator);

            short value = 2001;
            bool valid = validator.Validate(value);
            System.Diagnostics.Trace.WriteLine(validator.ErrorMessage);
            Assert.IsTrue(valid);

            short? value2 = 2001;
            valid = validator.Validate(value2);
            System.Diagnostics.Trace.WriteLine(validator.ErrorMessage);
            Assert.IsTrue(valid);

            value = 10000;
            valid = validator.Validate(value);
            Assert.IsFalse(valid);
        }
        [NUnit.Framework.Test]
        [NUnit.Framework.ExpectedException(ExceptionType=typeof(NullReferenceException))]
        public void GetValidatorException()
        {
            FieldValidator validator = FieldValidator.GetInstance(null);

        }
    }
}
