using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Util;
using CFW.Validators;
using CFW.Forms.Filters;
using CFW.Forms;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Sample.Table;

namespace WindowsApplicationSample1
{
    public partial class RadioButtonGroupElementTest : Form
    {
        Form2Input inputForm;
        TestTable3Table table = new TestTable3Table();
        TestTable3TableProperties properties = new TestTable3TableProperties();

        public RadioButtonGroupElementTest()
        {
            InitializeComponent();
            this.InitInputForm();
        }
        void InitInputForm()
        {
            inputForm = new Form2Input();
            inputForm.field1 = new TextBoxAdapterElement(
                this.textBox1,
                new NumberFilter<int>(),
                FieldValidator.GetInstance(properties.Field1));
            inputForm.field2 = new TextBoxAdapterElement(
                this.textBox2,
                new StringFilter(10, StringUtil.NormalizeMode.Default),
                FieldValidator.GetInstance(properties.Field2));
            inputForm.field3 = new TextBoxAdapterElement(
                this.textBox3, new DateTimeFilter(),
                FieldValidator.GetInstance(properties.Field3),
                "yyyy/MM/dd");
            inputForm.field4 = new TextBoxAdapterElement(
                this.textBox4,
                new NumberFilter<decimal?>(),
                FieldValidator.GetInstance(properties.Field4));
            inputForm.field5 = new RadioButtonGroupAdapterElement(
                new RadioButton[] { radioButton1, radioButton2, radioButton3 },
                new NumberFilter<short?>(),
                FieldValidator.GetInstance(properties.Field5)
                );
            inputForm.field6Sub1 = new TextBoxAdapterElement(
                this.textBox6Sub1,
                new NumberFilter<int?>(),
                FieldValidator.GetInstance(properties.Field6Sub1));
            inputForm.field6Sub2 = new TextBoxAdapterElement(
                this.textBox6Sub2,
                new NumberFilter<int?>(),
                FieldValidator.GetInstance(properties.Field6Sub2));



            inputForm.SetEntity(table);

            this.DisplayError();

        }
        private void button1_Click(object sender, EventArgs e)
        {
            inputForm.Bind();
            inputForm.RenderView();
            if (inputForm.IsValid)
            {
                this.ShowData();
            }
            else
            {
                this.DisplayError();
            }

        }
        void DisplayError()
        {
            this.field1Error.Text = (this.inputForm.field1.IsValid) ? "" : this.inputForm.field1.ErrorMessage;
            this.field2Error.Text = (this.inputForm.field2.IsValid) ? "" : this.inputForm.field2.ErrorMessage;
            this.field3Error.Text = (this.inputForm.field3.IsValid) ? "" : this.inputForm.field3.ErrorMessage;
            this.field4Error.Text = (this.inputForm.field4.IsValid) ? "" : this.inputForm.field4.ErrorMessage;
            this.field5Error.Text = (this.inputForm.field5.IsValid) ? "" : this.inputForm.field5.ErrorMessage;
            this.field6Sub1Error.Text = (this.inputForm.field6Sub1.IsValid) ? "" : this.inputForm.field6Sub1.ErrorMessage;
            this.field6Sub2Error.Text = (this.inputForm.field6Sub2.IsValid) ? "" : this.inputForm.field6Sub2.ErrorMessage;

        }
        void ShowData()
        {
            this.field1Error.Text = StringUtil.StringValue(this.inputForm.field1.GetValue());
            this.field2Error.Text = StringUtil.StringValue(this.inputForm.field2.GetValue());
            this.field3Error.Text = StringUtil.StringValue(this.inputForm.field3.GetValue());
            this.field4Error.Text = StringUtil.StringValue(this.inputForm.field4.GetValue());
            this.field5Error.Text = StringUtil.StringValue(this.inputForm.field5.GetValue());
            this.field6Sub1Error.Text = StringUtil.StringValue(this.inputForm.field6Sub1.GetValue());
            this.field6Sub2Error.Text = StringUtil.StringValue(this.inputForm.field6Sub2.GetValue());
        }

    }
}