using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace WindowsApplicationSample1
{
    public partial class Form5 : Form
    {
        CFW.Database.Connection connection;
        int count = 0;
        public Form5()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            DialogResult selectResult = folderBrowserDialog1.ShowDialog();
            if (selectResult != DialogResult.OK) return;


            count = 0;
            connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                connection.Open();

                parseFolders(folderBrowserDialog1.SelectedPath);

                label1.Text = "parsed " + count.ToString();
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
            finally
            {
                connection.Close();
            }

        }
        private void parseFolders(string dirname)
        {
            if (count > 10000) return;

            DirectoryInfo di = new DirectoryInfo(dirname);

            addNode(dirname, di.Parent.FullName);
            string[] files = Directory.GetFiles(dirname);
            foreach (string file in files)
            {
                FileInfo fi = new FileInfo(Path.Combine(dirname, file));
                addNode(fi.FullName, dirname);

            }
            string[] subdirectories = Directory.GetDirectories(dirname);
            foreach (string subdirecotry in subdirectories)
            {
                DirectoryInfo subInfo = new DirectoryInfo(Path.Combine(dirname, subdirecotry));
                parseFolders(subInfo.FullName);
            }

            
        }

        private void addNode(string name, string parentName)
        {
            string q = @"
declare @r int;
declare @id int;
declare @parent_id int;
if(exists(select * from sample_tree where sample_tree.name = @parent_name)) begin
    select @r = right_side,@parent_id = id
    from sample_tree
    where sample_tree.name = @parent_name;
end 
else begin
    select @r = isnull( max(right_side),0) + 1
    from sample_tree
    select @parent_id = 0
end
select @id = isnull( max(id),0) + 1
from sample_tree



UPDATE [sample_tree] SET right_side = right_side + 2 WHERE right_side >= @r;
UPDATE [sample_tree] SET left_side = left_side + 2 WHERE left_side >= @r;


insert into sample_tree( id,name,left_side,right_side,description,parent_id)
values(@id,@name,@r ,@r + 1,'',@parent_id)
";
            CFW.Database.Command command = new CFW.Database.Command(q, CommandType.Text);
            command.SetParameter(new CFW.Database.Parameter("@parent_name",parentName));
            command.SetParameter(new CFW.Database.Parameter("@name",name));

            connection.ExecuteUpdate(command);

            count++;
            if ((count % 100) == 0)
            {
                label1.Text = ": " + count.ToString() + "...";
                Application.DoEvents();
            }

        }

        private void button2_Click(object sender, EventArgs e)
        {
            IEnumerable<CFW.Acl.IAclRole> roles = new  CFW.Util.RepackEnumerable<CFW.Acl.Models.AclRolesEntity, CFW.Acl.IAclRole>( getRoles() );

            dataGridView1.DataSource = roles;
            dataGridView1.Refresh();

        }
        private List<CFW.Acl.Models.AclRolesEntity> getRoles()
        {
            connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                connection.Open();
                string query = @"SELECT parent.name AS parent_name, child.*
  FROM acl_roles as child
  LEFT OUTER JOIN acl_roles as parent
   ON child.left_side >  parent.left_side and child.left_side < parent.right_side

        AND parent.left_side = (SELECT MAX(left_side)
                          FROM acl_roles
                         WHERE child.left_side > left_side
                           AND child.left_side < right_side)
order by child.left_side
";
                CFW.Database.Command command = new CFW.Database.Command(query, CommandType.Text);

                DataSet rolesSet = connection.ExecuteQuery(command);

                List<CFW.Acl.Models.AclRolesEntity> list = new List<CFW.Acl.Models.AclRolesEntity>();
                DataRowCollection rolesRows = rolesSet.Tables[0].Rows;
                for (int i = 0; i < rolesRows.Count; i++)
                {
                    CFW.Acl.Models.AclRolesEntity role = new CFW.Acl.Models.AclRolesEntity();
                    role.Map(rolesRows[i]);
                    list.Add(role);
                }
                return list;
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
                return null;
            }
            finally
            {
                connection.Close();
            }
        }

    }
}