﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using CFW.Util;

public partial class tableRow_tableRowAdapterTest : System.Web.UI.Page
{
    System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
    long t1 = 0;
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        sw.Reset();
        sw.Start();
        WithInterface();
        sw.Stop();
        Label1.Text = "with interface " + sw.ElapsedMilliseconds.ToString() + "ms,t1=" + t1.ToString();

    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        sw.Reset();
        sw.Start();
        WithProperty();
        sw.Stop();
        Label2.Text = "with property" + sw.ElapsedMilliseconds.ToString() + "ms,t1=" + t1.ToString();

    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        sw.Reset();
        sw.Start();
        WithReflection();
        sw.Stop();
        Label3.Text = "with property" + sw.ElapsedMilliseconds.ToString() + "ms,t1=" + t1.ToString();

    }
    void WithInterface()
    {
        //with interface
        List<ConcreteTableRow> rows = new List<ConcreteTableRow>();
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = new ConcreteTableRow();
            row.SetValue("login_id", i.ToString());
            row.SetValue("random_key", i.ToString());
            row.SetValue("identity_data", i.ToString());
            row.SetValue("expire_date", DateTime.Now);

            rows.Add(row);
        }
        t1 = sw.ElapsedMilliseconds;
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = rows[i];
            object v = row.GetValue("login_id");
            v = row.GetValue("random_key");
            v = row.GetValue("identity_data");
            v = row.GetValue("expire_date");

        }
    }
    void WithProperty()
    {
        //with interface
        List<ConcreteTableRow> rows = new List<ConcreteTableRow>();
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = new ConcreteTableRow();
            row.LoginId = StringUtil.StringValue( i.ToString() );
            row.RandomKey = StringUtil.StringValue(i.ToString());
            row.IdentityData = StringUtil.StringValue(i.ToString());
            row.ExpireDate = DateUtil.DateValue( DateTime.Now );

            rows.Add(row);
        }
        t1 = sw.ElapsedMilliseconds;
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = rows[i];
            object v = null;
            v = row.LoginId;
            v = row.RandomKey;
            v = row.IdentityData;
            v = row.ExpireDate;

        }
    }
    void WithReflection()
    {
        //with interface
        List<ConcreteTableRow> rows = new List<ConcreteTableRow>();
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = new ConcreteTableRow();
            row.SetReflection("LoginId", i.ToString());
            row.SetReflection("RandomKey", i.ToString());
            row.SetReflection("IdentityData", i.ToString());
            row.SetReflection("ExpireDate", DateTime.Now);

            rows.Add(row);
        }
        t1 = sw.ElapsedMilliseconds;
        for (int i = 0; i < 10000; i++)
        {
            ConcreteTableRow row = rows[i];
            object v = row.GetReflection("LoginId");
            v = row.GetReflection("RandomKey");
            v = row.GetReflection("IdentityData");
            v = row.GetReflection("ExpireDate");

        }
    }
    interface ITableRow
    {
        object GetValue(string columnName);
        void SetValue(string columnName,object value);
    }
    class ConcreteTableRow : ITableRow
    {
        Type t;
        ///<summary>[login_id]</summary>
        protected string _LoginId;
        ///<summary>[login_id]</summary>
        public string LoginId
        {
            get { return _LoginId; }
            set { _LoginId = value; }
        }
        ///<summary>[random_key]</summary>
        protected string _RandomKey;
        ///<summary>[random_key]</summary>
        public string RandomKey
        {
            get { return _RandomKey; }
            set { _RandomKey = value; }
        }
        ///<summary>[identity_data]</summary>
        protected string _IdentityData;
        ///<summary>[identity_data]</summary>
        public string IdentityData
        {
            get { return _IdentityData; }
            set { _IdentityData = value; }
        }
        ///<summary>[expire_date]</summary>
        protected object _ExpireDate;
        ///<summary>[expire_date]</summary>
        public object ExpireDate
        {
            get { return _ExpireDate; }
            set { _ExpireDate = value; }
        }

        public ConcreteTableRow()
        {
            this.t = this.GetType();
        }
        #region ITableRow メンバ

        public object GetValue(string columnName)
        {

            if (columnName == "login_id")  return _LoginId;
            if (columnName == "random_key") return _RandomKey;
            if (columnName == "identity_data") return _IdentityData;
            if (columnName == "expire_date") return _ExpireDate;

            return null;
        }

        public void SetValue(string columnName, object value)
        {
            if (columnName == "login_id") _LoginId = StringUtil.StringValue(value);
            if (columnName == "random_key") _RandomKey = StringUtil.StringValue(value);
            if (columnName == "identity_data") _IdentityData = StringUtil.StringValue(value);
            if (columnName == "expire_date") _ExpireDate = DateUtil.DateValue(value);
        }

        #endregion
        public void SetReflection(string columnName, object value)
        {
            string pn = StringUtil.Camelize(columnName);
            //string pn = columnName;
            System.Reflection.FieldInfo fi = this.t.GetField("_" + pn);
            if (fi != null)
            {
                fi.SetValue(this, value);
            }

        }
        public object GetReflection(string columnName)
        {
            string pn = StringUtil.Camelize(columnName);
            //string pn = columnName;
            System.Reflection.FieldInfo fi = this.t.GetField("_" + pn);
            if (fi != null)
            {
                return fi.GetValue(this);
            }
            return null;

        }

        /// <summary>
        /// --実験
        /// （余計だと思われる）エスケープシーケンスの削除
        /// 縦タブ、EOF文字、null文字を削除する。
        /// 特にnullインジェクションを回避するためにシステム外部の入力に対して必ず通す必要がある。
        /// </summary>
        /// <param name="s">対象文字列</param>
        /// <returns>削除後の文字列</returns>
        public static string DeleteEscapeSequence(string s)
        {
            //実験 StringBuilderを使ってみる。やっぱりnewのコストは高いが10000回で50ms程度
            //StringBuilder builder = new StringBuilder(s);
            //builder.Replace("\v", string.Empty);
            //builder.Replace("\x1a", string.Empty);
            //builder.Replace("\x00", string.Empty);
            //return builder.ToString();

            //実験: 見つかったものを順次削除してみる 上と大差なし
            //string result = s;
            //if (result.IndexOf("\v") >= 0) result = result.Replace("\v", string.Empty);
            //if (result.IndexOf("\x1a") >= 0) result = result.Replace("\x1a", string.Empty);
            //if (result.IndexOf("\x00") >= 0) result = result.Replace("\x00", string.Empty);
            //return result;

            //Reader+Writer使ってみたが大差なし
            //System.IO.StringReader reader = new StringReader(s);
            //System.IO.StringWriter writer = new StringWriter();
            //while (reader.Peek() >= 0)
            //{
            //    int c = reader.Read();
            //    if (c == '\v') continue;
            //    if (c == '\x1a') continue;
            //    if (c == '\x00') continue;

            //    writer.Write((char)c);
            //}
            //reader.Close();
            //writer.Close();
            //return writer.ToString();
            //元 結局これが1番早い。データの長さによってはどうなるかわからんけど。
            string result = s.Replace("\v", string.Empty).Replace("\x1a", string.Empty).Replace("\x00", string.Empty);
            return result;
        }

    }
}
