using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Sample.Model;
using CFW.Sample.Model.TableRow;
using CFW.Sample.Model.TableProperty;
using CFW.Sample.Model.TableValidator;


namespace CFW.Sample.Model.TableFormAdapter
{
    /// <summary>
    /// table MAST_SITE Field`
    /// </summary>
    public class MastSiteTableFormAdapter : CFW.Forms.FormAdapter
	{
		private MastSiteTableRow table;

		///<summary>[SITE_CODE]</summary>
		public FormAdapterElement SiteCode;
		///<summary>[OPEN_DATE]</summary>
		public FormAdapterElement OpenDate;
		///<summary>[CLOSE_DATE]</summary>
		public FormAdapterElement CloseDate;
		///<summary>[SORT_SEQ]</summary>
		public FormAdapterElement SortSeq;
		///<summary>[NAME]</summary>
		public FormAdapterElement Name;
		///<summary>[ANK_NAME]</summary>
		public FormAdapterElement AnkName;
		///<summary>[COMPANY_CODE]</summary>
		public FormAdapterElement CompanyCode;
		///<summary>[SITE_URL]</summary>
		public FormAdapterElement SiteUrl;
		///<summary>[SITE_URL_OTHER]</summary>
		public FormAdapterElement SiteUrlOther;
		///<summary>[SITE_CATEGORY1]</summary>
		public FormAdapterElement SiteCategory1;
		///<summary>[SITE_CATEGORY2]</summary>
		public FormAdapterElement SiteCategory2;
		///<summary>[DEVICE_CODE]</summary>
		public FormAdapterElement DeviceCode;
		///<summary>[MENU_DEVICE_CODE]</summary>
		public FormAdapterElement MenuDeviceCode;
		///<summary>[MENU_ADTYPE_CODE]</summary>
		public FormAdapterElement MenuAdtypeCode;
		///<summary>[GOODS_CATEGORY_CODE]</summary>
		public FormAdapterElement GoodsCategoryCode;
		///<summary>[CARRIER_CODE1]</summary>
		public FormAdapterElement CarrierCode1;
		///<summary>[CARRIER_CODE2]</summary>
		public FormAdapterElement CarrierCode2;
		///<summary>[CARRIER_CODE3]</summary>
		public FormAdapterElement CarrierCode3;
		///<summary>[CARRIER_CODE4]</summary>
		public FormAdapterElement CarrierCode4;
		///<summary>[MEDIA_COST_RATE]</summary>
		public FormAdapterElement MediaCostRate;
		///<summary>[AGENCY_MARGIN_RATE]</summary>
		public FormAdapterElement AgencyMarginRate;
		///<summary>[SP_OPEN_FLAG]</summary>
		public FormAdapterElement SpOpenFlag;
		///<summary>[PM_OPEN_FLAG]</summary>
		public FormAdapterElement PmOpenFlag;
		///<summary>[IO_OPEN_FLAG]</summary>
		public FormAdapterElement IoOpenFlag;
		///<summary>[AD_GUIDE_OPEN_FLAG]</summary>
		public FormAdapterElement AdGuideOpenFlag;
		///<summary>[IMPRESSION]</summary>
		public FormAdapterElement Impression;
		///<summary>[IMPRESSION_TERM]</summary>
		public FormAdapterElement ImpressionTerm;
		///<summary>[IMPRESSION_TOPPAGE]</summary>
		public FormAdapterElement ImpressionToppage;
		///<summary>[IMPRESSION_TOPPAGE_TERM]</summary>
		public FormAdapterElement ImpressionToppageTerm;
		///<summary>[UNIQUE_USER]</summary>
		public FormAdapterElement UniqueUser;
		///<summary>[UNIQUE_USER_TERM]</summary>
		public FormAdapterElement UniqueUserTerm;
		///<summary>[UNIQUE_USER_TOPPAGE]</summary>
		public FormAdapterElement UniqueUserToppage;
		///<summary>[UNIQUE_USER_TOPPAGE_TERM]</summary>
		public FormAdapterElement UniqueUserToppageTerm;
		///<summary>[MALE_RATE]</summary>
		public FormAdapterElement MaleRate;
		///<summary>[FEMALE_RATE]</summary>
		public FormAdapterElement FemaleRate;
		///<summary>[PUBLISHED_YEAR]</summary>
		public FormAdapterElement PublishedYear;
		///<summary>[PUBLISHED_MONTH]</summary>
		public FormAdapterElement PublishedMonth;
		///<summary>[PUBLISHED_DAY]</summary>
		public FormAdapterElement PublishedDay;
		///<summary>[PUBLISHED_DATA_KIND]</summary>
		public FormAdapterElement PublishedDataKind;
		///<summary>[UPPER_SITE_CODE]</summary>
		public FormAdapterElement UpperSiteCode;
		///<summary>[PAYMENT_COMPANY]</summary>
		public FormAdapterElement PaymentCompany;
		///<summary>[BUSINESS_DIRECT_FLAG]</summary>
		public FormAdapterElement BusinessDirectFlag;
		///<summary>[ADSERVER_FLAG]</summary>
		public FormAdapterElement AdserverFlag;
		///<summary>[SPECIALMENU_FLAG]</summary>
		public FormAdapterElement SpecialmenuFlag;
		///<summary>[TOP_OPEN_FLAG]</summary>
		public FormAdapterElement TopOpenFlag;
		///<summary>[OPEN_MENU_COUNT]</summary>
		public FormAdapterElement OpenMenuCount;
		///<summary>[MAKE_DATE]</summary>
		public FormAdapterElement MakeDate;
		///<summary>[DOCUMENT_ADDRESS]</summary>
		public FormAdapterElement DocumentAddress;
		///<summary>[AG_COMPANY_CODE]</summary>
		public FormAdapterElement AgCompanyCode;
		///<summary>[INSIDE_OPEN_LEVEL]</summary>
		public FormAdapterElement InsideOpenLevel;
		///<summary>[OUTSIDE_OPEN_LEVEL]</summary>
		public FormAdapterElement OutsideOpenLevel;
		///<summary>[HOME_RATE]</summary>
		public FormAdapterElement HomeRate;
		///<summary>[WORK_RATE]</summary>
		public FormAdapterElement WorkRate;
		///<summary>[OVERLAP_RATE]</summary>
		public FormAdapterElement OverlapRate;
		///<summary>[BUSINESS_REP_DIRECT_FLAG]</summary>
		public FormAdapterElement BusinessRepDirectFlag;
		///<summary>[CLIENT_SITE_FLAG]</summary>
		public FormAdapterElement ClientSiteFlag;
		///<summary>[PRINT_UPPER_SITE_CODE]</summary>
		public FormAdapterElement PrintUpperSiteCode;
		///<summary>[TEAM_CODE]</summary>
		public FormAdapterElement TeamCode;
		///<summary>[CHECK_NAME]</summary>
		public FormAdapterElement CheckName;
		///<summary>[VALID_FLAG]</summary>
		public FormAdapterElement ValidFlag;
		///<summary>[INSERT_DATE_TIME]</summary>
		public FormAdapterElement InsertDateTime;
		///<summary>[INSERT_OPERATOR_CODE]</summary>
		public FormAdapterElement InsertOperatorCode;
		///<summary>[UPDATE_DATE_TIME]</summary>
		public FormAdapterElement UpdateDateTime;
		///<summary>[OPERATOR_CODE]</summary>
		public FormAdapterElement OperatorCode;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override CFW.Models.Entity GetEntity()
        {
            return this.table;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			this.SiteCode.Render();
			this.OpenDate.Render();
			this.CloseDate.Render();
			this.SortSeq.Render();
			this.Name.Render();
			this.AnkName.Render();
			this.CompanyCode.Render();
			this.SiteUrl.Render();
			this.SiteUrlOther.Render();
			this.SiteCategory1.Render();
			this.SiteCategory2.Render();
			this.DeviceCode.Render();
			this.MenuDeviceCode.Render();
			this.MenuAdtypeCode.Render();
			this.GoodsCategoryCode.Render();
			this.CarrierCode1.Render();
			this.CarrierCode2.Render();
			this.CarrierCode3.Render();
			this.CarrierCode4.Render();
			this.MediaCostRate.Render();
			this.AgencyMarginRate.Render();
			this.SpOpenFlag.Render();
			this.PmOpenFlag.Render();
			this.IoOpenFlag.Render();
			this.AdGuideOpenFlag.Render();
			this.Impression.Render();
			this.ImpressionTerm.Render();
			this.ImpressionToppage.Render();
			this.ImpressionToppageTerm.Render();
			this.UniqueUser.Render();
			this.UniqueUserTerm.Render();
			this.UniqueUserToppage.Render();
			this.UniqueUserToppageTerm.Render();
			this.MaleRate.Render();
			this.FemaleRate.Render();
			this.PublishedYear.Render();
			this.PublishedMonth.Render();
			this.PublishedDay.Render();
			this.PublishedDataKind.Render();
			this.UpperSiteCode.Render();
			this.PaymentCompany.Render();
			this.BusinessDirectFlag.Render();
			this.AdserverFlag.Render();
			this.SpecialmenuFlag.Render();
			this.TopOpenFlag.Render();
			this.OpenMenuCount.Render();
			this.MakeDate.Render();
			this.DocumentAddress.Render();
			this.AgCompanyCode.Render();
			this.InsideOpenLevel.Render();
			this.OutsideOpenLevel.Render();
			this.HomeRate.Render();
			this.WorkRate.Render();
			this.OverlapRate.Render();
			this.BusinessRepDirectFlag.Render();
			this.ClientSiteFlag.Render();
			this.PrintUpperSiteCode.Render();
			this.TeamCode.Render();
			this.CheckName.Render();
			this.ValidFlag.Render();
			this.InsertDateTime.Render();
			this.InsertOperatorCode.Render();
			this.UpdateDateTime.Render();
			this.OperatorCode.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(CFW.Models.Entity entity)
        {
            this.table = (MastSiteTableRow)entity;
			this.SiteCode.SetValue(this.table.SiteCode);
			this.OpenDate.SetValue(this.table.OpenDate);
			this.CloseDate.SetValue(this.table.CloseDate);
			this.SortSeq.SetValue(this.table.SortSeq);
			this.Name.SetValue(this.table.Name);
			this.AnkName.SetValue(this.table.AnkName);
			this.CompanyCode.SetValue(this.table.CompanyCode);
			this.SiteUrl.SetValue(this.table.SiteUrl);
			this.SiteUrlOther.SetValue(this.table.SiteUrlOther);
			this.SiteCategory1.SetValue(this.table.SiteCategory1);
			this.SiteCategory2.SetValue(this.table.SiteCategory2);
			this.DeviceCode.SetValue(this.table.DeviceCode);
			this.MenuDeviceCode.SetValue(this.table.MenuDeviceCode);
			this.MenuAdtypeCode.SetValue(this.table.MenuAdtypeCode);
			this.GoodsCategoryCode.SetValue(this.table.GoodsCategoryCode);
			this.CarrierCode1.SetValue(this.table.CarrierCode1);
			this.CarrierCode2.SetValue(this.table.CarrierCode2);
			this.CarrierCode3.SetValue(this.table.CarrierCode3);
			this.CarrierCode4.SetValue(this.table.CarrierCode4);
			this.MediaCostRate.SetValue(this.table.MediaCostRate);
			this.AgencyMarginRate.SetValue(this.table.AgencyMarginRate);
			this.SpOpenFlag.SetValue(this.table.SpOpenFlag);
			this.PmOpenFlag.SetValue(this.table.PmOpenFlag);
			this.IoOpenFlag.SetValue(this.table.IoOpenFlag);
			this.AdGuideOpenFlag.SetValue(this.table.AdGuideOpenFlag);
			this.Impression.SetValue(this.table.Impression);
			this.ImpressionTerm.SetValue(this.table.ImpressionTerm);
			this.ImpressionToppage.SetValue(this.table.ImpressionToppage);
			this.ImpressionToppageTerm.SetValue(this.table.ImpressionToppageTerm);
			this.UniqueUser.SetValue(this.table.UniqueUser);
			this.UniqueUserTerm.SetValue(this.table.UniqueUserTerm);
			this.UniqueUserToppage.SetValue(this.table.UniqueUserToppage);
			this.UniqueUserToppageTerm.SetValue(this.table.UniqueUserToppageTerm);
			this.MaleRate.SetValue(this.table.MaleRate);
			this.FemaleRate.SetValue(this.table.FemaleRate);
			this.PublishedYear.SetValue(this.table.PublishedYear);
			this.PublishedMonth.SetValue(this.table.PublishedMonth);
			this.PublishedDay.SetValue(this.table.PublishedDay);
			this.PublishedDataKind.SetValue(this.table.PublishedDataKind);
			this.UpperSiteCode.SetValue(this.table.UpperSiteCode);
			this.PaymentCompany.SetValue(this.table.PaymentCompany);
			this.BusinessDirectFlag.SetValue(this.table.BusinessDirectFlag);
			this.AdserverFlag.SetValue(this.table.AdserverFlag);
			this.SpecialmenuFlag.SetValue(this.table.SpecialmenuFlag);
			this.TopOpenFlag.SetValue(this.table.TopOpenFlag);
			this.OpenMenuCount.SetValue(this.table.OpenMenuCount);
			this.MakeDate.SetValue(this.table.MakeDate);
			this.DocumentAddress.SetValue(this.table.DocumentAddress);
			this.AgCompanyCode.SetValue(this.table.AgCompanyCode);
			this.InsideOpenLevel.SetValue(this.table.InsideOpenLevel);
			this.OutsideOpenLevel.SetValue(this.table.OutsideOpenLevel);
			this.HomeRate.SetValue(this.table.HomeRate);
			this.WorkRate.SetValue(this.table.WorkRate);
			this.OverlapRate.SetValue(this.table.OverlapRate);
			this.BusinessRepDirectFlag.SetValue(this.table.BusinessRepDirectFlag);
			this.ClientSiteFlag.SetValue(this.table.ClientSiteFlag);
			this.PrintUpperSiteCode.SetValue(this.table.PrintUpperSiteCode);
			this.TeamCode.SetValue(this.table.TeamCode);
			this.CheckName.SetValue(this.table.CheckName);
			this.ValidFlag.SetValue(this.table.ValidFlag);
			this.InsertDateTime.SetValue(this.table.InsertDateTime);
			this.InsertOperatorCode.SetValue(this.table.InsertOperatorCode);
			this.UpdateDateTime.SetValue(this.table.UpdateDateTime);
			this.OperatorCode.SetValue(this.table.OperatorCode);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			this.table.SiteCode = StringUtil.StringValue(this.SiteCode.GetValue());
			this.table.OpenDate = StringUtil.StringValue(this.OpenDate.GetValue());
			this.table.CloseDate = StringUtil.StringValue(this.CloseDate.GetValue());
			this.table.SortSeq = NumberUtil.Value<Int16?>(this.SortSeq.GetValue());
			this.table.Name = StringUtil.StringValue(this.Name.GetValue());
			this.table.AnkName = StringUtil.StringValue(this.AnkName.GetValue());
			this.table.CompanyCode = StringUtil.StringValue(this.CompanyCode.GetValue());
			this.table.SiteUrl = StringUtil.StringValue(this.SiteUrl.GetValue());
			this.table.SiteUrlOther = StringUtil.StringValue(this.SiteUrlOther.GetValue());
			this.table.SiteCategory1 = NumberUtil.Value<Int16?>(this.SiteCategory1.GetValue());
			this.table.SiteCategory2 = NumberUtil.Value<Int16?>(this.SiteCategory2.GetValue());
			this.table.DeviceCode = NumberUtil.Value<Int16>(this.DeviceCode.GetValue());
			this.table.MenuDeviceCode = NumberUtil.Value<Int16?>(this.MenuDeviceCode.GetValue());
			this.table.MenuAdtypeCode = NumberUtil.Value<Int16?>(this.MenuAdtypeCode.GetValue());
			this.table.GoodsCategoryCode = NumberUtil.Value<Int16?>(this.GoodsCategoryCode.GetValue());
			this.table.CarrierCode1 = NumberUtil.Value<Int16?>(this.CarrierCode1.GetValue());
			this.table.CarrierCode2 = NumberUtil.Value<Int16?>(this.CarrierCode2.GetValue());
			this.table.CarrierCode3 = NumberUtil.Value<Int16?>(this.CarrierCode3.GetValue());
			this.table.CarrierCode4 = NumberUtil.Value<Int16?>(this.CarrierCode4.GetValue());
			this.table.MediaCostRate = NumberUtil.Value<Decimal?>(this.MediaCostRate.GetValue());
			this.table.AgencyMarginRate = NumberUtil.Value<Decimal?>(this.AgencyMarginRate.GetValue());
			this.table.SpOpenFlag = NumberUtil.Value<Int16?>(this.SpOpenFlag.GetValue());
			this.table.PmOpenFlag = NumberUtil.Value<Int16?>(this.PmOpenFlag.GetValue());
			this.table.IoOpenFlag = NumberUtil.Value<Int16?>(this.IoOpenFlag.GetValue());
			this.table.AdGuideOpenFlag = NumberUtil.Value<Int16?>(this.AdGuideOpenFlag.GetValue());
			this.table.Impression = NumberUtil.Value<Decimal?>(this.Impression.GetValue());
			this.table.ImpressionTerm = NumberUtil.Value<Int16?>(this.ImpressionTerm.GetValue());
			this.table.ImpressionToppage = NumberUtil.Value<Decimal?>(this.ImpressionToppage.GetValue());
			this.table.ImpressionToppageTerm = NumberUtil.Value<Int16?>(this.ImpressionToppageTerm.GetValue());
			this.table.UniqueUser = NumberUtil.Value<Decimal?>(this.UniqueUser.GetValue());
			this.table.UniqueUserTerm = NumberUtil.Value<Int16?>(this.UniqueUserTerm.GetValue());
			this.table.UniqueUserToppage = NumberUtil.Value<Decimal?>(this.UniqueUserToppage.GetValue());
			this.table.UniqueUserToppageTerm = NumberUtil.Value<Int16?>(this.UniqueUserToppageTerm.GetValue());
			this.table.MaleRate = NumberUtil.Value<Decimal?>(this.MaleRate.GetValue());
			this.table.FemaleRate = NumberUtil.Value<Decimal?>(this.FemaleRate.GetValue());
			this.table.PublishedYear = NumberUtil.Value<Int16?>(this.PublishedYear.GetValue());
			this.table.PublishedMonth = NumberUtil.Value<Int16?>(this.PublishedMonth.GetValue());
			this.table.PublishedDay = NumberUtil.Value<Int16?>(this.PublishedDay.GetValue());
			this.table.PublishedDataKind = NumberUtil.Value<Int16?>(this.PublishedDataKind.GetValue());
			this.table.UpperSiteCode = StringUtil.StringValue(this.UpperSiteCode.GetValue());
			this.table.PaymentCompany = StringUtil.StringValue(this.PaymentCompany.GetValue());
			this.table.BusinessDirectFlag = NumberUtil.Value<Int16?>(this.BusinessDirectFlag.GetValue());
			this.table.AdserverFlag = NumberUtil.Value<Int16?>(this.AdserverFlag.GetValue());
			this.table.SpecialmenuFlag = NumberUtil.Value<Int16?>(this.SpecialmenuFlag.GetValue());
			this.table.TopOpenFlag = NumberUtil.Value<Int16?>(this.TopOpenFlag.GetValue());
			this.table.OpenMenuCount = NumberUtil.Value<Int16?>(this.OpenMenuCount.GetValue());
			this.table.MakeDate = StringUtil.StringValue(this.MakeDate.GetValue());
			this.table.DocumentAddress = StringUtil.StringValue(this.DocumentAddress.GetValue());
			this.table.AgCompanyCode = StringUtil.StringValue(this.AgCompanyCode.GetValue());
			this.table.InsideOpenLevel = NumberUtil.Value<Int16?>(this.InsideOpenLevel.GetValue());
			this.table.OutsideOpenLevel = NumberUtil.Value<Int16?>(this.OutsideOpenLevel.GetValue());
			this.table.HomeRate = NumberUtil.Value<Decimal?>(this.HomeRate.GetValue());
			this.table.WorkRate = NumberUtil.Value<Decimal?>(this.WorkRate.GetValue());
			this.table.OverlapRate = NumberUtil.Value<Decimal?>(this.OverlapRate.GetValue());
			this.table.BusinessRepDirectFlag = NumberUtil.Value<Int16?>(this.BusinessRepDirectFlag.GetValue());
			this.table.ClientSiteFlag = NumberUtil.Value<Int16?>(this.ClientSiteFlag.GetValue());
			this.table.PrintUpperSiteCode = StringUtil.StringValue(this.PrintUpperSiteCode.GetValue());
			this.table.TeamCode = NumberUtil.Value<Int16?>(this.TeamCode.GetValue());
			this.table.CheckName = StringUtil.StringValue(this.CheckName.GetValue());
			this.table.ValidFlag = NumberUtil.Value<Int16?>(this.ValidFlag.GetValue());
			this.table.InsertDateTime = DateUtil.DateValue(this.InsertDateTime.GetValue());
			this.table.InsertOperatorCode = StringUtil.StringValue(this.InsertOperatorCode.GetValue());
			this.table.UpdateDateTime = DateUtil.DateValue(this.UpdateDateTime.GetValue());
			this.table.OperatorCode = StringUtil.StringValue(this.OperatorCode.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			this.SiteCode.UpdateField();
			this.OpenDate.UpdateField();
			this.CloseDate.UpdateField();
			this.SortSeq.UpdateField();
			this.Name.UpdateField();
			this.AnkName.UpdateField();
			this.CompanyCode.UpdateField();
			this.SiteUrl.UpdateField();
			this.SiteUrlOther.UpdateField();
			this.SiteCategory1.UpdateField();
			this.SiteCategory2.UpdateField();
			this.DeviceCode.UpdateField();
			this.MenuDeviceCode.UpdateField();
			this.MenuAdtypeCode.UpdateField();
			this.GoodsCategoryCode.UpdateField();
			this.CarrierCode1.UpdateField();
			this.CarrierCode2.UpdateField();
			this.CarrierCode3.UpdateField();
			this.CarrierCode4.UpdateField();
			this.MediaCostRate.UpdateField();
			this.AgencyMarginRate.UpdateField();
			this.SpOpenFlag.UpdateField();
			this.PmOpenFlag.UpdateField();
			this.IoOpenFlag.UpdateField();
			this.AdGuideOpenFlag.UpdateField();
			this.Impression.UpdateField();
			this.ImpressionTerm.UpdateField();
			this.ImpressionToppage.UpdateField();
			this.ImpressionToppageTerm.UpdateField();
			this.UniqueUser.UpdateField();
			this.UniqueUserTerm.UpdateField();
			this.UniqueUserToppage.UpdateField();
			this.UniqueUserToppageTerm.UpdateField();
			this.MaleRate.UpdateField();
			this.FemaleRate.UpdateField();
			this.PublishedYear.UpdateField();
			this.PublishedMonth.UpdateField();
			this.PublishedDay.UpdateField();
			this.PublishedDataKind.UpdateField();
			this.UpperSiteCode.UpdateField();
			this.PaymentCompany.UpdateField();
			this.BusinessDirectFlag.UpdateField();
			this.AdserverFlag.UpdateField();
			this.SpecialmenuFlag.UpdateField();
			this.TopOpenFlag.UpdateField();
			this.OpenMenuCount.UpdateField();
			this.MakeDate.UpdateField();
			this.DocumentAddress.UpdateField();
			this.AgCompanyCode.UpdateField();
			this.InsideOpenLevel.UpdateField();
			this.OutsideOpenLevel.UpdateField();
			this.HomeRate.UpdateField();
			this.WorkRate.UpdateField();
			this.OverlapRate.UpdateField();
			this.BusinessRepDirectFlag.UpdateField();
			this.ClientSiteFlag.UpdateField();
			this.PrintUpperSiteCode.UpdateField();
			this.TeamCode.UpdateField();
			this.CheckName.UpdateField();
			this.ValidFlag.UpdateField();
			this.InsertDateTime.UpdateField();
			this.InsertOperatorCode.UpdateField();
			this.UpdateDateTime.UpdateField();
			this.OperatorCode.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			if(!this.SiteCode.Validate()){
				valid = false;
				this.messages.Add(this.SiteCode.ErrorMessage);
			}
			if(!this.OpenDate.Validate()){
				valid = false;
				this.messages.Add(this.OpenDate.ErrorMessage);
			}
			if(!this.CloseDate.Validate()){
				valid = false;
				this.messages.Add(this.CloseDate.ErrorMessage);
			}
			if(!this.SortSeq.Validate()){
				valid = false;
				this.messages.Add(this.SortSeq.ErrorMessage);
			}
			if(!this.Name.Validate()){
				valid = false;
				this.messages.Add(this.Name.ErrorMessage);
			}
			if(!this.AnkName.Validate()){
				valid = false;
				this.messages.Add(this.AnkName.ErrorMessage);
			}
			if(!this.CompanyCode.Validate()){
				valid = false;
				this.messages.Add(this.CompanyCode.ErrorMessage);
			}
			if(!this.SiteUrl.Validate()){
				valid = false;
				this.messages.Add(this.SiteUrl.ErrorMessage);
			}
			if(!this.SiteUrlOther.Validate()){
				valid = false;
				this.messages.Add(this.SiteUrlOther.ErrorMessage);
			}
			if(!this.SiteCategory1.Validate()){
				valid = false;
				this.messages.Add(this.SiteCategory1.ErrorMessage);
			}
			if(!this.SiteCategory2.Validate()){
				valid = false;
				this.messages.Add(this.SiteCategory2.ErrorMessage);
			}
			if(!this.DeviceCode.Validate()){
				valid = false;
				this.messages.Add(this.DeviceCode.ErrorMessage);
			}
			if(!this.MenuDeviceCode.Validate()){
				valid = false;
				this.messages.Add(this.MenuDeviceCode.ErrorMessage);
			}
			if(!this.MenuAdtypeCode.Validate()){
				valid = false;
				this.messages.Add(this.MenuAdtypeCode.ErrorMessage);
			}
			if(!this.GoodsCategoryCode.Validate()){
				valid = false;
				this.messages.Add(this.GoodsCategoryCode.ErrorMessage);
			}
			if(!this.CarrierCode1.Validate()){
				valid = false;
				this.messages.Add(this.CarrierCode1.ErrorMessage);
			}
			if(!this.CarrierCode2.Validate()){
				valid = false;
				this.messages.Add(this.CarrierCode2.ErrorMessage);
			}
			if(!this.CarrierCode3.Validate()){
				valid = false;
				this.messages.Add(this.CarrierCode3.ErrorMessage);
			}
			if(!this.CarrierCode4.Validate()){
				valid = false;
				this.messages.Add(this.CarrierCode4.ErrorMessage);
			}
			if(!this.MediaCostRate.Validate()){
				valid = false;
				this.messages.Add(this.MediaCostRate.ErrorMessage);
			}
			if(!this.AgencyMarginRate.Validate()){
				valid = false;
				this.messages.Add(this.AgencyMarginRate.ErrorMessage);
			}
			if(!this.SpOpenFlag.Validate()){
				valid = false;
				this.messages.Add(this.SpOpenFlag.ErrorMessage);
			}
			if(!this.PmOpenFlag.Validate()){
				valid = false;
				this.messages.Add(this.PmOpenFlag.ErrorMessage);
			}
			if(!this.IoOpenFlag.Validate()){
				valid = false;
				this.messages.Add(this.IoOpenFlag.ErrorMessage);
			}
			if(!this.AdGuideOpenFlag.Validate()){
				valid = false;
				this.messages.Add(this.AdGuideOpenFlag.ErrorMessage);
			}
			if(!this.Impression.Validate()){
				valid = false;
				this.messages.Add(this.Impression.ErrorMessage);
			}
			if(!this.ImpressionTerm.Validate()){
				valid = false;
				this.messages.Add(this.ImpressionTerm.ErrorMessage);
			}
			if(!this.ImpressionToppage.Validate()){
				valid = false;
				this.messages.Add(this.ImpressionToppage.ErrorMessage);
			}
			if(!this.ImpressionToppageTerm.Validate()){
				valid = false;
				this.messages.Add(this.ImpressionToppageTerm.ErrorMessage);
			}
			if(!this.UniqueUser.Validate()){
				valid = false;
				this.messages.Add(this.UniqueUser.ErrorMessage);
			}
			if(!this.UniqueUserTerm.Validate()){
				valid = false;
				this.messages.Add(this.UniqueUserTerm.ErrorMessage);
			}
			if(!this.UniqueUserToppage.Validate()){
				valid = false;
				this.messages.Add(this.UniqueUserToppage.ErrorMessage);
			}
			if(!this.UniqueUserToppageTerm.Validate()){
				valid = false;
				this.messages.Add(this.UniqueUserToppageTerm.ErrorMessage);
			}
			if(!this.MaleRate.Validate()){
				valid = false;
				this.messages.Add(this.MaleRate.ErrorMessage);
			}
			if(!this.FemaleRate.Validate()){
				valid = false;
				this.messages.Add(this.FemaleRate.ErrorMessage);
			}
			if(!this.PublishedYear.Validate()){
				valid = false;
				this.messages.Add(this.PublishedYear.ErrorMessage);
			}
			if(!this.PublishedMonth.Validate()){
				valid = false;
				this.messages.Add(this.PublishedMonth.ErrorMessage);
			}
			if(!this.PublishedDay.Validate()){
				valid = false;
				this.messages.Add(this.PublishedDay.ErrorMessage);
			}
			if(!this.PublishedDataKind.Validate()){
				valid = false;
				this.messages.Add(this.PublishedDataKind.ErrorMessage);
			}
			if(!this.UpperSiteCode.Validate()){
				valid = false;
				this.messages.Add(this.UpperSiteCode.ErrorMessage);
			}
			if(!this.PaymentCompany.Validate()){
				valid = false;
				this.messages.Add(this.PaymentCompany.ErrorMessage);
			}
			if(!this.BusinessDirectFlag.Validate()){
				valid = false;
				this.messages.Add(this.BusinessDirectFlag.ErrorMessage);
			}
			if(!this.AdserverFlag.Validate()){
				valid = false;
				this.messages.Add(this.AdserverFlag.ErrorMessage);
			}
			if(!this.SpecialmenuFlag.Validate()){
				valid = false;
				this.messages.Add(this.SpecialmenuFlag.ErrorMessage);
			}
			if(!this.TopOpenFlag.Validate()){
				valid = false;
				this.messages.Add(this.TopOpenFlag.ErrorMessage);
			}
			if(!this.OpenMenuCount.Validate()){
				valid = false;
				this.messages.Add(this.OpenMenuCount.ErrorMessage);
			}
			if(!this.MakeDate.Validate()){
				valid = false;
				this.messages.Add(this.MakeDate.ErrorMessage);
			}
			if(!this.DocumentAddress.Validate()){
				valid = false;
				this.messages.Add(this.DocumentAddress.ErrorMessage);
			}
			if(!this.AgCompanyCode.Validate()){
				valid = false;
				this.messages.Add(this.AgCompanyCode.ErrorMessage);
			}
			if(!this.InsideOpenLevel.Validate()){
				valid = false;
				this.messages.Add(this.InsideOpenLevel.ErrorMessage);
			}
			if(!this.OutsideOpenLevel.Validate()){
				valid = false;
				this.messages.Add(this.OutsideOpenLevel.ErrorMessage);
			}
			if(!this.HomeRate.Validate()){
				valid = false;
				this.messages.Add(this.HomeRate.ErrorMessage);
			}
			if(!this.WorkRate.Validate()){
				valid = false;
				this.messages.Add(this.WorkRate.ErrorMessage);
			}
			if(!this.OverlapRate.Validate()){
				valid = false;
				this.messages.Add(this.OverlapRate.ErrorMessage);
			}
			if(!this.BusinessRepDirectFlag.Validate()){
				valid = false;
				this.messages.Add(this.BusinessRepDirectFlag.ErrorMessage);
			}
			if(!this.ClientSiteFlag.Validate()){
				valid = false;
				this.messages.Add(this.ClientSiteFlag.ErrorMessage);
			}
			if(!this.PrintUpperSiteCode.Validate()){
				valid = false;
				this.messages.Add(this.PrintUpperSiteCode.ErrorMessage);
			}
			if(!this.TeamCode.Validate()){
				valid = false;
				this.messages.Add(this.TeamCode.ErrorMessage);
			}
			if(!this.CheckName.Validate()){
				valid = false;
				this.messages.Add(this.CheckName.ErrorMessage);
			}
			if(!this.ValidFlag.Validate()){
				valid = false;
				this.messages.Add(this.ValidFlag.ErrorMessage);
			}
			if(!this.InsertDateTime.Validate()){
				valid = false;
				this.messages.Add(this.InsertDateTime.ErrorMessage);
			}
			if(!this.InsertOperatorCode.Validate()){
				valid = false;
				this.messages.Add(this.InsertOperatorCode.ErrorMessage);
			}
			if(!this.UpdateDateTime.Validate()){
				valid = false;
				this.messages.Add(this.UpdateDateTime.ErrorMessage);
			}
			if(!this.OperatorCode.Validate()){
				valid = false;
				this.messages.Add(this.OperatorCode.ErrorMessage);
			}
			

            return valid;
        }
		
	}

}