using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;


namespace SQLiteSample.Model.TableAccess
{
    /// <summary>
    /// table[t1]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class T1TableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// t1ɑΉvpeB
        /// </summary>
        private T1TableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private T1TableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new T1TableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public T1TableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  T1TableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public T1TableAccess(Connection db, T1TableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// t1֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(T1TableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// t1֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(T1TableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// t1֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(T1TableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// t1s̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(T1TableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// t1s̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// t1̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(T1TableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// t1̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public T1TableRow Get(T1TableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            T1TableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new T1TableRow();
                data.FromDataRow(result.Tables[0].Rows[0],"t1");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// t1̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<T1TableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            T1TableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<T1TableRow> list = new List<T1TableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new T1TableRow();
	                data.FromDataRow(result.Tables[0].Rows[0],"t1");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// t1ւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(T1TableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("t1");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.Value.DoUpdate) command.AddInsert(property.Value, data.Value);
            
            return command;
        }
        /// <summary>
        /// t1ւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(T1TableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("t1");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Value.DoUpdate) command.AddUpdate(property.Value, data.Value);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// t1ւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(T1TableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("t1");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Value.DoUpdate) command.AddUpdate(property.Value, data.Value);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// t1ւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("t1");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// t1ւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(T1TableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("t1");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// t1ւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(T1TableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("t1");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// t1ւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(T1TableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("t1");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Value);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// t1ւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("t1");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Value);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// t1select list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".value AS " + columnAliasPrefix + "value" );
            

            return builder.ToString().Substring(1);
        }
    }
}
