using System;
using System.Collections.Generic;
using System.Text;

namespace Config
{
    public class Configuration
    {
        protected string baseKey;

        public string BaseKey
        {
            get { return baseKey; }
            set { baseKey = value; }
        }
        protected Dictionary<string, string> dictionary;

        public  Dictionary<string, string> Dictionary
        {
            get { return dictionary; }
            set { dictionary = value; }
        }
        public Configuration()
        {
            baseKey = "";
            dictionary = new Dictionary<string, string>();
        }
        public Configuration GetSection(string[] name)
        {
            Configuration section = new Configuration();
            section.baseKey = BuildKey(name);
            section.dictionary = this.dictionary;

            return section;
        }
        public string GetString(string[] name)
        {
            return this.GetString(name, null);
        }
        public string GetString(string[] name,string defaultValue)
        {
            string key =  BuildKey(name);
            if (this.dictionary.ContainsKey(key))
            {
                return this.dictionary[key];
            }

            return defaultValue;
        }

        string BuildKey(string[] name)
        {
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.Append(this.baseKey);
            foreach (string s in name)
            {
                keyBuilder.Append(".");
                keyBuilder.Append(s);

            }
            return keyBuilder.ToString();
        }

    }
}
