using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Test4;
using CFW.Sample.Test4.TableRow;
using CFW.Sample.Test4.TableProperty;

namespace CFW.Sample.Test4.TableRow
{
    /// <summary>
    /// table test_table4 Field`
    /// </summary>
    [Serializable()]
    public class TestTable4TableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[int_field]</summary>
        protected System.Nullable<Int32> _IntField;
        ///<summary>[int_field]</summary>
        public System.Nullable<Int32> IntField{
            get{return _IntField;}
            set{_IntField = value;}
        }
        ///<summary>[smallint_field]</summary>
        protected System.Nullable<Int16> _SmallintField;
        ///<summary>[smallint_field]</summary>
        public System.Nullable<Int16> SmallintField{
            get{return _SmallintField;}
            set{_SmallintField = value;}
        }
        ///<summary>[long_field]</summary>
        protected System.Nullable<Int64> _LongField;
        ///<summary>[long_field]</summary>
        public System.Nullable<Int64> LongField{
            get{return _LongField;}
            set{_LongField = value;}
        }
        ///<summary>[tinyint_field]</summary>
        protected System.Nullable<Byte> _TinyintField;
        ///<summary>[tinyint_field]</summary>
        public System.Nullable<Byte> TinyintField{
            get{return _TinyintField;}
            set{_TinyintField = value;}
        }
        ///<summary>[char_field]</summary>
        protected string _CharField;
        ///<summary>[char_field]</summary>
        public string CharField{
            get{return _CharField;}
            set{_CharField = value;}
        }
        ///<summary>[varchar_field]</summary>
        protected string _VarcharField;
        ///<summary>[varchar_field]</summary>
        public string VarcharField{
            get{return _VarcharField;}
            set{_VarcharField = value;}
        }
        ///<summary>[nchar_field]</summary>
        protected string _NcharField;
        ///<summary>[nchar_field]</summary>
        public string NcharField{
            get{return _NcharField;}
            set{_NcharField = value;}
        }
        ///<summary>[nvarchar_Field]</summary>
        protected string _NvarcharField;
        ///<summary>[nvarchar_Field]</summary>
        public string NvarcharField{
            get{return _NvarcharField;}
            set{_NvarcharField = value;}
        }
        ///<summary>[datetime_field]</summary>
        protected object _DatetimeField;
        ///<summary>[datetime_field]</summary>
        public object DatetimeField{
            get{return _DatetimeField;}
            set{_DatetimeField = value;}
        }
        ///<summary>[smalldatetime_field]</summary>
        protected object _SmalldatetimeField;
        ///<summary>[smalldatetime_field]</summary>
        public object SmalldatetimeField{
            get{return _SmalldatetimeField;}
            set{_SmalldatetimeField = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public TestTable4TableRow() : base()
        {
            _Id = 0;
            _IntField = null;
            _SmallintField = null;
            _LongField = null;
            _TinyintField = null;
            _CharField = "";
            _VarcharField = "";
            _NcharField = "";
            _NvarcharField = "";
            _DatetimeField = null;
            _SmalldatetimeField = null;
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void Map(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "int_field");if(ColumnExists(row,columnName)) _IntField = NumberUtil.Value<Int32?>( row[columnName] );
            columnName = BuildColumnName(alias, "smallint_field");if(ColumnExists(row,columnName)) _SmallintField = NumberUtil.Value<Int16?>( row[columnName] );
            columnName = BuildColumnName(alias, "long_field");if(ColumnExists(row,columnName)) _LongField = NumberUtil.Value<Int64?>( row[columnName] );
            columnName = BuildColumnName(alias, "tinyint_field");if(ColumnExists(row,columnName)) _TinyintField = NumberUtil.Value<Byte?>( row[columnName] );
            columnName = BuildColumnName(alias, "char_field");if(ColumnExists(row,columnName)) _CharField = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "varchar_field");if(ColumnExists(row,columnName)) _VarcharField = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "nchar_field");if(ColumnExists(row,columnName)) _NcharField = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "nvarchar_Field");if(ColumnExists(row,columnName)) _NvarcharField = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "datetime_field");if(ColumnExists(row,columnName)) _DatetimeField = DateUtil.DateValue( row[columnName] );
            columnName = BuildColumnName(alias, "smalldatetime_field");if(ColumnExists(row,columnName)) _SmalldatetimeField = DateUtil.DateValue( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "int_field") _IntField = NumberUtil.Value<Int32?>( value );
            if(name ==  "smallint_field") _SmallintField = NumberUtil.Value<Int16?>( value );
            if(name ==  "long_field") _LongField = NumberUtil.Value<Int64?>( value );
            if(name ==  "tinyint_field") _TinyintField = NumberUtil.Value<Byte?>( value );
            if(name ==  "char_field") _CharField = StringUtil.StringValue( value );
            if(name ==  "varchar_field") _VarcharField = StringUtil.StringValue( value );
            if(name ==  "nchar_field") _NcharField = StringUtil.StringValue( value );
            if(name ==  "nvarchar_Field") _NvarcharField = StringUtil.StringValue( value );
            if(name ==  "datetime_field") _DatetimeField = DateUtil.DateValue( value );
            if(name ==  "smalldatetime_field") _SmalldatetimeField = DateUtil.DateValue( value );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override object GetValue(string name)
        {
            if (name == "id") return _Id;
            if (name == "int_field") return _IntField;
            if (name == "smallint_field") return _SmallintField;
            if (name == "long_field") return _LongField;
            if (name == "tinyint_field") return _TinyintField;
            if (name == "char_field") return _CharField;
            if (name == "varchar_field") return _VarcharField;
            if (name == "nchar_field") return _NcharField;
            if (name == "nvarchar_Field") return _NvarcharField;
            if (name == "datetime_field") return _DatetimeField;
            if (name == "smalldatetime_field") return _SmalldatetimeField;

            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            TestTable4TableRow clone = new TestTable4TableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(TestTable4TableRow source)
        {
            this.Id = source.Id;
            this.IntField = source.IntField;
            this.SmallintField = source.SmallintField;
            this.LongField = source.LongField;
            this.TinyintField = source.TinyintField;
            this.CharField = source.CharField;
            this.VarcharField = source.VarcharField;
            this.NcharField = source.NcharField;
            this.NvarcharField = source.NvarcharField;
            this.DatetimeField = source.DatetimeField;
            this.SmalldatetimeField = source.SmalldatetimeField;
            
        }
    }

}