using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using CFW;
using CFW.Database;
using NUnit.Framework;

namespace CFWDatabaseTest.SQLite
{
    [NUnit.Framework.TestFixture]
    public class SQLiteMemConnectionTest
    {
        CFW.Database.Connection con;
        [NUnit.Framework.TestFixtureSetUp]
        public void InitClass()
        {
            con = CFW.Database.ConnectionFactory.GetConnectionByName("sqlitemem");

            con.Open();
            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = @"CREATE TABLE test1(
id int,
field1 varchar(255),
field2 datetime ,
field3 decimal
,constraint pk_test1 primary key(id)
);";
            int rc  = con.ExecuteUpdate(command);


        }
        [NUnit.Framework.TestFixtureTearDown]
        public void TerminateClass()
        {
            con.Close();
        }
        [Test(Description = "PȍXVNG[s")]
        public void ExecuteUpdate()
        {

            //ǉ

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test1 values(@id,@field1,@field2,@field3)";
            insert.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.Decimal, 101101.56M, 10, 2));

            int result = con.ExecuteUpdate(insert);
            Assert.Greater(result, 0);
            //ǉf[^݊mF
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["id"]);
            Assert.AreEqual("ZZZZ", row["field1"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55),CFW.Util.DateUtil.DateValue(  row["field2"] ));
            Assert.AreEqual(101101.56M, row["field3"]);


            //update

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test1 set field1 = @field1,field2 = @field2 where id = @id ";
            update.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));

            result = con.ExecuteUpdate(update);
            Assert.Greater(result, 0);

            //XVf[^݊mF
            select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["id"]);
            Assert.AreEqual("YYYY", row["field1"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55),CFW.Util.DateUtil.DateValue(  row["field2"] ));
            Assert.AreEqual(101101.56M, row["field3"]);


            //delete

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete from test1 where id = @id";
            delete.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);

            //XVf[^݊mF
            select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);
        }

    }
}
