using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;

namespace CFWDatabaseTest.Expressions
{
    [TestFixture]
    public class ExpressionTest
    {
        FieldProperty field1;
        FieldProperty field2;
        FieldProperty field3;
        FieldProperty field4;
        FieldProperty field5;
        FieldProperty field6Sub1;
        FieldProperty field6Sub2;

        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;

        [NUnit.Framework.SetUp]
        public void init()
        {
            field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 10, 0, false, 0, true);
            field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 50, 0, 0, false, "", false);
            field3 = FieldProperty.NewInstance("datetime", "test_table3", "field3", "[field3]", 16, 23, 3, true, null, false);
            field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 12, 10, 2, true, null, false);
            field5 = FieldProperty.NewInstance("smallint", "test_table3", "field5", "[field5]", 2, 5, 0, true, null, false);
            field6Sub1 = FieldProperty.NewInstance("int", "test_table3", "field6_sub1", "[field6_sub1]", 4, 10, 0, true, null, false);
            field6Sub2 = FieldProperty.NewInstance("int", "test_table3", "field6_sub2", "[field6_sub2]", 4, 10, 0, true, null, false);

            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
        }

        [NUnit.Framework.TearDown]
        public void term()
        {
        }

        [Test]
        public void ComplexExpressionTest()
        {
            ExpressionFactory expr = con.getExpressionFactory();
            ComplexCondition condition = expr.complex()
            .add(expr.columnValue(field1, 1, ">="))
            .and(expr.columnValue(field1, 10, "<=","@p1"))
            .or(expr.columnValue(field1, 100, "<="))
            .or(expr.columnValue(field2, "101010101", "="))
            .or(expr.columnValue(field2, new string[] { "10", "20" }, "IN"))
            .and(
                new ComplexCondition()
                .add(expr.columnValue(field1, 1, ">="))
                .and(expr.columnValue(field1, 10, "<="))
                .or(expr.columnValue(field1, 100, "<="))
                .or(expr.columnValue(field2, "101010101", "="))
                .or(expr.columnValue(field2, new string[] { "10", "20" }, "IN"))
                .or(expr.columnValue(field2, new string[] { "10", "20" }, "BETWEEN"))

            );
            condition.buildExpression();
            string expression = condition.getExpression();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @p1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) AND ( test_table3.field1 >= @test_table3__field1 AND test_table3.field1 <= @test_table3__field1 OR test_table3.field1 <= @test_table3__field1 OR test_table3.field2 = @test_table3__field2 OR test_table3.field2 IN (@test_table3__field2_0,@test_table3__field2_1) OR test_table3.field2 BETWEEN @test_table3__field2_0 AND @test_table3__field2_1 ) )", expression);

            List<Parameter> parameters = condition.getParameters();
            Assert.AreEqual(14,parameters.Count);

            Assert.AreEqual("@test_table3__field1", parameters[0].ParameterName);
            Assert.AreEqual(1, parameters[0].ParameterValue);

            Assert.AreEqual("@p1", parameters[1].ParameterName);
            Assert.AreEqual(10, parameters[1].ParameterValue);

            Assert.AreEqual("@test_table3__field1", parameters[2].ParameterName);
            Assert.AreEqual(100, parameters[2].ParameterValue);

            Assert.AreEqual("@test_table3__field2", parameters[3].ParameterName);
            Assert.AreEqual("101010101", parameters[3].ParameterValue);

            Assert.AreEqual("@test_table3__field2_0", parameters[4].ParameterName);
            Assert.AreEqual("10", parameters[4].ParameterValue);

            Assert.AreEqual("@test_table3__field2_1", parameters[5].ParameterName);
            Assert.AreEqual("20", parameters[5].ParameterValue);

            Assert.AreEqual("@test_table3__field1", parameters[6].ParameterName);
            Assert.AreEqual(1, parameters[6].ParameterValue);

            Assert.AreEqual("@test_table3__field1", parameters[7].ParameterName);
            Assert.AreEqual(10, parameters[7].ParameterValue);
        }
        [Test]
        public void RelationExpressionTest()
        {
            ExpressionFactory expr = con.getExpressionFactory();
            ComplexCondition condition = expr.complex()
            .add(expr.relation(field1, field2))
            .add(expr.relation("FF1", "FF2"))
            .add(expr.relation(field1, field2,"<"))
            .add(expr.relation("FF1", "FF2",">"));
            condition.buildExpression();
            string expression = condition.getExpression();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("( test_table3.field1 = test_table3.field2 AND FF1 = FF2 AND test_table3.field1 < test_table3.field2 AND FF1 > FF2 )", expression);

            List<Parameter> parameters = condition.getParameters();
            Assert.AreEqual(0, parameters.Count);


        }
        [Test]
        public void StringExpressionTest()
        {
            ExpressionFactory expr = con.getExpressionFactory();
            ComplexCondition condition = expr.complex()
            .add(expr.strings("field1 is @p1", new Parameter[] { new Parameter("@p1",100) }));

            condition.buildExpression();
            string expression = condition.getExpression();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("( field1 is @p1 )", expression);

            List<Parameter> parameters = condition.getParameters();
            Assert.AreEqual(1, parameters.Count);

            Assert.AreEqual("@p1", parameters[0].ParameterName);
            Assert.AreEqual(100, parameters[0].ParameterValue);
        }
    }
}
