using System;
using System.Collections.Generic;
using System.Text;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using NUnit.Framework;

namespace CFWDatabaseTest.DbWebServiceReference
{
    [NUnit.Framework.TestFixture]
    public class Transactions
    {
        FieldProperty field1;
        FieldProperty field2;
        FieldProperty field3;
        FieldProperty field4;
        FieldProperty field5;
        FieldProperty field6Sub1;
        FieldProperty field6Sub2;
        [NUnit.Framework.SetUp]
        public void init()
        {
            field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 10, 0, false, 0, true);
            field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 50, 0, 0, false, "", false);
            field3 = FieldProperty.NewInstance("datetime", "test_table3", "field3", "[field3]", 16, 23, 3, true, null, false);
            field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 12, 10, 2, true, null, false);
            field5 = FieldProperty.NewInstance("smallint", "test_table3", "field5", "[field5]", 2, 5, 0, true, null, false);
            field6Sub1 = FieldProperty.NewInstance("int", "test_table3", "field6_sub1", "[field6_sub1]", 4, 10, 0, true, null, false);
            field6Sub2 = FieldProperty.NewInstance("int", "test_table3", "field6_sub2", "[field6_sub2]", 4, 10, 0, true, null, false);

        }


        [Test]
        public void Rollback()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            TestTableRow original = new TestTableRow();
            original.Field1 = 101;
            original.Field2 = "1234567890";
            original.Field3 = new DateTime(1970, 2, 3);
            original.Field4 = 123.45M;
            original.Field5 = 101;
            original.Field6Sub1 = 10100;
            original.Field6Sub2 = 101000;


            try
            {
                con.Open();
                con.BeginTransaction();
                CFW.Database.TableCommand.TableInsertCommand command = new CFW.Database.TableCommand.TableInsertCommand("test_table3");
                command.AddInsert(field1, original.Field1);
                command.AddInsert(field2, original.Field2);
                command.AddInsert(field3, original.Field3);
                command.AddInsert(field4, original.Field4);
                command.AddInsert(field5, original.Field5);
                command.AddInsert(field6Sub1, original.Field6Sub1);
                command.AddInsert(field6Sub2, original.Field6Sub2);

                int result = con.ExecuteUpdate(command.GetCommand());
                Assert.Greater(result, 0);
                con.RollbackTransaction();

            }
            finally
            {
                con.Close();

            }
            try
            {
                con.Open();
                List<TestTableRow> testList = get(101);

                Assert.AreEqual(0, testList.Count);

            }
            finally
            {
                con.Close();

            }


        }
        [Test]
        public void Commit()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            TestTableRow original = new TestTableRow();
            original.Field1 = 101;
            original.Field2 = "1234567890";
            original.Field3 = new DateTime(1970, 2, 3);
            original.Field4 = 123.45M;
            original.Field5 = 101;
            original.Field6Sub1 = 10100;
            original.Field6Sub2 = 101000;


            try
            {
                con.Open(System.Data.IsolationLevel.ReadUncommitted, true);

                CFW.Database.TableCommand.TableInsertCommand command = new CFW.Database.TableCommand.TableInsertCommand("test_table3");
                command.AddInsert(field1, original.Field1);
                command.AddInsert(field2, original.Field2);
                command.AddInsert(field3, original.Field3);
                command.AddInsert(field4, original.Field4);
                command.AddInsert(field5, original.Field5);
                command.AddInsert(field6Sub1, original.Field6Sub1);
                command.AddInsert(field6Sub2, original.Field6Sub2);

                int result = con.ExecuteUpdate(command.GetCommand());
                Assert.Greater(result, 0);

            }
            finally
            {
                con.Close(true);

            }

            try
            {
                con.Open();
                List<TestTableRow> testList = get(101);

                Assert.AreEqual(1, testList.Count);

            }
            finally
            {
                con.Close();

            }
            try
            {

                con.Open();

                CFW.Database.TableCommand.TableDeleteCommand delete = new CFW.Database.TableCommand.TableDeleteCommand("test_table3");
                delete.AddWhere(new ColumnValueCondition(field1, original.Field1, "="));

                int result = con.ExecuteUpdate(delete.GetCommand());
                Assert.Greater(result, 0);

            }
            finally
            {
                con.Close();

            }



        }
        List<TestTableRow> get(int f1)
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            try
            {
                con.Open();
                CFW.Database.TableCommand.TableSelectCommand command = new CFW.Database.TableCommand.TableSelectCommand("test_table3");
                command.AddSelect(field1);
                command.AddSelect(field2);
                command.AddSelect(field3);
                command.AddSelect(field4);
                command.AddSelect(field5);
                command.AddSelect(field6Sub1);
                command.AddSelect(field6Sub2);

                command.AddWhere(new ColumnValueCondition(field1, f1, "="));

                List<TestTableRow> testList = con.ExecuteQueryAsTableRows<TestTableRow>(command.GetCommand());
                return testList;

            }
            finally
            {
                con.Close();

            }

        }
    }
}
