using System;
using System.Collections.Generic;
using System.Text;
using CFW.Database;
using CFW.Database.CommandBuilder;
using CFW.Models;
using CFW.FieldProperties;
using CFW.Test.Models;
using NUnit.Framework;
using CFW.Database.Expressions;
using CFW.Database.Conditions;

namespace CFWDatabaseTest.CommandBuilder
{
    [NUnit.Framework.TestFixture]
    public class SelectTest
    {
        Connection connection;
        TestTable1Property test1Property;
        TestTable2Property test2Property;
        TestTable3Property test3Property;
        TestTable4Property test4Property;


        [NUnit.Framework.SetUp]
        public void setup()
        {
            connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();

            test1Property = new TestTable1Property();
            test2Property = new TestTable2Property();
            test3Property = new TestTable3Property();
            test4Property = new TestTable4Property();

        }
        [NUnit.Framework.TearDown]
        public void tearDown()
        {
            connection.Close();
        }
        [NUnit.Framework.Test]
        public void SelectTest1()
        {
            ExpressionFactory cf = connection.getExpressionFactory();

            SelectCommandBuilder select = new SelectCommandBuilder(connection);
            select.from(test3Property)
            .joinLeft(test4Property,
                cf.relation(test3Property.field1, test4Property.id),
                cf.relation(test3Property.field2, test4Property.intField))
            .select(test3Property.Fields())
            .select(test4Property.Fields())
            .where(cf.columnValue(test3Property.field4, 1))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f1"))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f2"))
            .orderBy(test3Property.field1);

            Command command = select.getCommand();
            Assert.AreEqual("SELECT test_table3.field1 AS test_table3__field1,test_table3.field2 AS test_table3__field2,test_table3.field3 AS test_table3__field3,test_table3.field4 AS test_table3__field4,test_table3.field5 AS test_table3__field5,test_table3.field6_sub1 AS test_table3__field6_sub1,test_table3.field6_sub2 AS test_table3__field6_sub2,test_table4.id AS test_table4__id,test_table4.int_field AS test_table4__int_field,test_table4.smallint_field AS test_table4__smallint_field,test_table4.long_field AS test_table4__long_field,test_table4.tinyint_field AS test_table4__tinyint_field,test_table4.char_field AS test_table4__char_field,test_table4.varchar_field AS test_table4__varchar_field,test_table4.nchar_field AS test_table4__nchar_field,test_table4.nvarchar_Field AS test_table4__nvarchar_Field,test_table4.datetime_field AS test_table4__datetime_field,test_table4.smalldatetime_field AS test_table4__smalldatetime_field FROM test_table3 LEFT JOIN test_table4 ON test_table3.field1 = test_table4.id AND test_table3.field2 = test_table4.int_field WHERE test_table3.field4 = @test_table3__field4 AND test_table3.field5 = @f1 AND test_table3.field5 = @f2 ORDER BY test_table3.field1 ASC", command.Text);

        }
        [NUnit.Framework.Test]
        public void SelectTest2()
        {
            ExpressionFactory cf = connection.getExpressionFactory();

            SelectCommandBuilder select = new SelectCommandBuilder(connection);
            select.from(test3Property)
            .joinLeft(test4Property,
                cf.relation(test3Property.field1, test4Property.id),
                cf.relation(test3Property.field2, test4Property.intField))
            .where(cf.columnValue(test3Property.field4, 1))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f1"))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f2"))
            .orderBy(test3Property.field1);

            Command command = select.getCommand();
            Assert.AreEqual("SELECT test_table3.*,test_table4.* FROM test_table3 LEFT JOIN test_table4 ON test_table3.field1 = test_table4.id AND test_table3.field2 = test_table4.int_field WHERE test_table3.field4 = @test_table3__field4 AND test_table3.field5 = @f1 AND test_table3.field5 = @f2 ORDER BY test_table3.field1 ASC", command.Text);

        }
        [NUnit.Framework.Test]
        public void SelectTest3()
        {
            ExpressionFactory cf = connection.getExpressionFactory();
            test3Property.Alias = "t1";
            test4Property.Alias = "t2";
            SelectCommandBuilder select = new SelectCommandBuilder(connection);
            select.from(test3Property)
            .joinLeft(test4Property,
                cf.relation(test3Property.field1, test4Property.id),
                cf.relation(test3Property.field2, test4Property.intField))
            .select(test3Property.Fields())
            .select(test4Property.Fields())
            .where(cf.columnValue(test3Property.field4, 1))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f1"))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f2"))
            .orderBy(test3Property.field1);

            Command command = select.getCommand();
            Assert.AreEqual("SELECT t1.field1 AS t1__field1,t1.field2 AS t1__field2,t1.field3 AS t1__field3,t1.field4 AS t1__field4,t1.field5 AS t1__field5,t1.field6_sub1 AS t1__field6_sub1,t1.field6_sub2 AS t1__field6_sub2,t2.id AS t2__id,t2.int_field AS t2__int_field,t2.smallint_field AS t2__smallint_field,t2.long_field AS t2__long_field,t2.tinyint_field AS t2__tinyint_field,t2.char_field AS t2__char_field,t2.varchar_field AS t2__varchar_field,t2.nchar_field AS t2__nchar_field,t2.nvarchar_Field AS t2__nvarchar_Field,t2.datetime_field AS t2__datetime_field,t2.smalldatetime_field AS t2__smalldatetime_field FROM test_table3 t1 LEFT JOIN test_table4 t2 ON t1.field1 = t2.id AND t1.field2 = t2.int_field WHERE t1.field4 = @t1__field4 AND t1.field5 = @f1 AND t1.field5 = @f2 ORDER BY t1.field1 ASC", command.Text);

        }
        [NUnit.Framework.Test]
        public void SelectTest4()
        {
            ExpressionFactory cf = connection.getExpressionFactory();
            test3Property.Alias = "t1";
            test4Property.Alias = "t2";
            SelectCommandBuilder select = new SelectCommandBuilder(connection);
            select.from("BASE_TABLE")
            .joinLeft("MAST_CODE","SELECTABLE_NAME1",
                cf.strings("BASE_TABLE.CODE1 = SELECTABLE_NAME1.CODE"),
                cf.strings("SELECTABLE_NAME1.DELETE_FLAG = 0")
            )
            .joinLeft("MAST_CODE","SELECTABLE_NAME2",
                cf.strings("BASE_TABLE.CODE1 = SELECTABLE_NAME2.CODE"),
                cf.strings("SELECTABLE_NAME2.DELETE_FLAG = 0")
            )
            .where(cf.strings("BASE_TABLE.DELETE_FLAG = 0"))
            .where(cf.columnValue("BASE_TABLE.FROM_DATE", CFW.Util.DateUtil.Parse("2010/1/1"), ">=", "@d1"))
            .where(cf.columnValue("BASE_TABLE.FROM_DATE", CFW.Util.DateUtil.Parse("2010/12/31"), "<=", "@d2"))
            .orderBy("BASE_TABLE.COLUMN1");


            Command command = select.getCommand();
            Assert.AreEqual("SELECT BASE_TABLE.*,SELECTABLE_NAME1.*,SELECTABLE_NAME2.* FROM BASE_TABLE LEFT JOIN MAST_CODE SELECTABLE_NAME1 ON BASE_TABLE.CODE1 = SELECTABLE_NAME1.CODE AND SELECTABLE_NAME1.DELETE_FLAG = 0 LEFT JOIN MAST_CODE SELECTABLE_NAME2 ON BASE_TABLE.CODE1 = SELECTABLE_NAME2.CODE AND SELECTABLE_NAME2.DELETE_FLAG = 0 WHERE BASE_TABLE.DELETE_FLAG = 0 AND BASE_TABLE.FROM_DATE >= @d1 AND BASE_TABLE.FROM_DATE <= @d2 ORDER BY BASE_TABLE.COLUMN1 ASC", command.Text);

        }
        [NUnit.Framework.Test]
        public void SelectTest5()
        {
            ExpressionFactory cf = connection.getExpressionFactory();
            test3Property.Alias = "t1";
            test4Property.Alias = "t2";

            SelectCommandBuilder select = new SelectCommandBuilder(connection);
            select.from(test3Property)
            .joinLeft(test4Property,
                cf.relation(test3Property.field1, test4Property.id),
                cf.relation(test3Property.field2, test4Property.intField))
            .select(test3Property.field1)
            .select("COUNT(*) AS FIELDCOOUNT")
            .select("SUM(test_table3.field2) AS f2summary")
            .where(cf.columnValue(test3Property.field4, 1))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f1"))
            .where(cf.columnValue(test3Property.field5, 2, "=", "@f2"))
            .groupBy(test3Property.field1)
            .having(cf.columnValue("COUNT(*)", 10, "<", "@sum"))
            .orderBy(test3Property.field1);

            Command command = select.getCommand();
            Assert.AreEqual("SELECT t1.field1 AS t1__field1,COUNT(*) AS FIELDCOOUNT,SUM(test_table3.field2) AS f2summary FROM test_table3 t1 LEFT JOIN test_table4 t2 ON t1.field1 = t2.id AND t1.field2 = t2.int_field WHERE t1.field4 = @t1__field4 AND t1.field5 = @f1 AND t1.field5 = @f2 GROUP BY t1.field1 HAVING COUNT(*) < @sum ORDER BY t1.field1 ASC", command.Text);

        }
    }
}
