using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using NUnit.Framework;
using CFW.Models;
using CFW.Database;
using CFW.Database.CommandBuilder;
using CFW.Database.Expressions;
using CFW.Database.Test.AdventureWorks.Models;


namespace CFWDatabaseTest.AdventureWorks
{
    [TestFixture]
    public class SelectTest2
    {
        [SetUp]
        public void setup()
        {

        }
        [TearDown]
        public void tearDown()
        {
        }
        [Test]
        public void selectTest()
        {
            SalesOrderHeaderProperty orderProperty = new SalesOrderHeaderProperty();
            SalesOrderDetailProperty detailProperty = new SalesOrderDetailProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            connection.QuotedIdentifier = true;
            try
            {
                connection.Open();

                ExpressionFactory ef = connection.getExpressionFactory();
                SelectCommandBuilder select = new SelectCommandBuilder( connection );
                select.from( orderProperty )
                .joinLeft( detailProperty, ef.relation(orderProperty.salesOrderID, detailProperty.salesOrderID) )
                .select( orderProperty.orderDate, "" )
                .select( orderProperty.salesOrderID, "ID" )
                .select( "SUM(OrderQty)", "v" )
                .select( "SUM(OrderQty * UnitPrice)", "zv" )
                .where( ef.columnValue(orderProperty.salesOrderID, new int[] { 71902, 71935 }, "BETWEEN") )
                .groupBy( orderProperty.orderDate )
                .groupBy( orderProperty.salesOrderID )
                .having( ef.strings("SUM(OrderQty * UnitPrice) > @lowerPrice", new Parameter("@lowerPrice", 1000) ) )
                .orderBy( orderProperty.orderDate )
                .orderBy( orderProperty.salesOrderID );

                DataSet result = connection.ExecuteQuery( select.getCommand() );

                Assert.AreEqual( 4, result.Tables[0].Rows.Count );
            }
            finally
            {
                connection.Close();

            }

        }

    }
}
