using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using NUnit.Framework;
using CFW.Models;
using CFW.Database;
using CFW.Database.CommandBuilder;
using CFW.Database.Expressions;
using CFW.Database.Test.AdventureWorks.Models;

namespace CFWDatabaseTest.AdventureWorks
{
    [TestFixture]
    public class SelectTest
    {
        
        [SetUp]
        public void setup()
        {

        }
        [TearDown]
        public void tearDown()
        {
        }
        [Test]
        public void selectTest()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            try
            {
                connection.Open();
                //A
                Association modelAssociation = new Association("model", Association.Multiplicity.TO_ONE, productModelProperty,
                    new RelationCondition(productProperty.productModelID, productModelProperty.productModelID)
                );

                Association categoryAssociation = new Association("category", Association.Multiplicity.TO_ONE, productCategoryProperty,
                    new RelationCondition(productProperty.productCategoryID, productCategoryProperty.productCategoryID)
                );

                ExpressionFactory expr = connection.getExpressionFactory();
                //
                CFW.Database.Criteria c = new CFW.Database.Criteria();
                c.where(expr.columnValue(productProperty.productID, 880))
                    .orderBy(productProperty.productCategoryID)
                    .orderBy(productProperty.productModelID)
                    .orderBy(productProperty.productID);
                //f[^\[X猟
                CFW.Database.DataSource<ProductEntity> productDataSource = connection.getDataSource<ProductEntity>();
                productDataSource.setProperty(productProperty);
                List<ProductEntity> products = productDataSource.find(c, new Association[] { modelAssociation, categoryAssociation });

                Assert.AreEqual(1, products.Count);
            }
            finally
            {
                connection.Close();

            }

        }
        [Test]
        public void selectTest1()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            ExpressionFactory expr = connection.getExpressionFactory();
            try
            {
                connection.Open();
                SelectCommandBuilder builder = new SelectCommandBuilder(connection);
                builder.from(productProperty)
                .joinLeft(productModelProperty, expr.relation(productProperty.productModelID, productModelProperty.productModelID))
                .joinLeft(productCategoryProperty, expr.relation(productProperty.productCategoryID, productCategoryProperty.productCategoryID))
                .select(productProperty.Fields())
                .select(productModelProperty.Fields())
                .select(productCategoryProperty.Fields())
                .orderBy(productProperty.productCategoryID)
                .orderBy(productProperty.productModelID)
                .orderBy(productProperty.productID);

                DataSet result = connection.ExecuteQuery(builder.getCommand());
                Assert.AreEqual(295, result.Tables[0].Rows.Count);
            }
            finally
            {
                connection.Close();
            }
        }
        [Test]
        public void selectTest2()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            ExpressionFactory expr = connection.getExpressionFactory();
            try
            {
                connection.Open();
                SelectCommandBuilder builder = new SelectCommandBuilder(connection);
                builder.from(productProperty)
                .joinLeft(productModelProperty, expr.relation(productProperty.productModelID, productModelProperty.productModelID))
                .joinLeft(productCategoryProperty, expr.relation(productProperty.productCategoryID, productCategoryProperty.productCategoryID))
                .select(productProperty.Fields())
                .select(productModelProperty.Fields())
                .select(productCategoryProperty.Fields())
                .where(expr.columnValue(productProperty.productID,880))
                .orderBy(productProperty.productCategoryID)
                .orderBy(productProperty.productModelID)
                .orderBy(productProperty.productID);


                DataSet result = connection.ExecuteQuery(builder.getCommand());
                Assert.AreEqual(1, result.Tables[0].Rows.Count);

                ProductEntity product = new ProductEntity();
                product.Map(result.Tables[0].Rows[0], productProperty.EntityName);

                ProductModelEntity model = new ProductModelEntity();
                model.Map(result.Tables[0].Rows[0], productModelProperty.EntityName);

                ProductCategoryEntity category = new ProductCategoryEntity();
                category.Map(result.Tables[0].Rows[0], productCategoryProperty.EntityName);

                Assert.AreEqual(880, product.productID);
                Assert.AreEqual("HY-1023-70", product.productNumber);
                Assert.AreEqual("Silver", product.color);
                Assert.AreEqual(20.5663M, product.standardCost);

            }
            finally
            {
                connection.Close();
            }

        }
        [Test]
        public void selectTest3()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            try
            {
                connection.Open();
                //A
                Association modelAssociation = new Association("model", Association.Multiplicity.TO_ONE, productModelProperty,
                    new RelationCondition(productProperty.productModelID, productModelProperty.productModelID)
                );

                Association categoryAssociation = new Association("category", Association.Multiplicity.TO_ONE, productCategoryProperty,
                    new RelationCondition(productProperty.productCategoryID, productCategoryProperty.productCategoryID)
                );

                ExpressionFactory expr = connection.getExpressionFactory();
                //
                CFW.Database.Criteria c = new CFW.Database.Criteria();
                c.where(expr.columnValue(productProperty.productID, 880))
                    .orderBy(productProperty.productCategoryID)
                    .orderBy(productProperty.productModelID)
                    .orderBy(productProperty.productID);
                //A^ZNg
                AssociationSelect<ProductEntity> select = new AssociationSelect<ProductEntity>(connection);
                select.from(productProperty);
                select.associate(modelAssociation, categoryAssociation);
                select.select(productProperty.Fields());
                select.select(productModelProperty.Fields());
                select.select(productCategoryProperty.Fields());
                select.setCriteria(c);

                List<ProductEntity> products = select.queryAsEntity();
                Assert.AreEqual(1, products.Count);
            }
            finally
            {
                connection.Close();
            }

        }
        [Test]
        public void selectTest4()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            try
            {
                connection.Open();
                //A
                Association modelAssociation = new Association("model", Association.Multiplicity.TO_ONE, productModelProperty,
                    new RelationCondition(productProperty.productModelID, productModelProperty.productModelID)
                );

                Association categoryAssociation = new Association("category", Association.Multiplicity.TO_ONE, productCategoryProperty,
                    new RelationCondition(productProperty.productCategoryID, productCategoryProperty.productCategoryID)
                );

                ExpressionFactory expr = connection.getExpressionFactory();
                //A^ZNg
                AssociationSelect<ProductEntity> select = new AssociationSelect<ProductEntity>(connection);
                select.from(productProperty);
                select.associate(modelAssociation, categoryAssociation);
                select.select("COUNT(*)","PRODUCT_COUNT");

                DataSet productCountSet = select.query();
                Assert.AreEqual(1, productCountSet.Tables[0].Rows.Count);
                Assert.AreEqual(295, productCountSet.Tables[0].Rows[0]["PRODUCT_COUNT"]);
            }
            finally
            {
                connection.Close();
            }

        }
        [Test]
        public void selectTest5()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            try
            {
                connection.Open();
                //A
                Association productAssociation = new Association("products", Association.Multiplicity.TO_MANY, productProperty,
                    new RelationCondition(productModelProperty.productModelID, productProperty.productModelID)
                );
                productAssociation.add(new Association("category", Association.Multiplicity.TO_ONE, productCategoryProperty,
                    new RelationCondition(productProperty.productCategoryID, productCategoryProperty.productCategoryID)
                    )
                );

                ExpressionFactory expr = connection.getExpressionFactory();
                //
                CFW.Database.Criteria c = new CFW.Database.Criteria();
                c.where(expr.columnValue(productModelProperty.productModelID, 116))
                    .orderBy(productProperty.productCategoryID)
                    .orderBy(productProperty.productModelID)
                    .orderBy(productProperty.productID);
                //A^ZNg
                AssociationSelect<ProductModelEntity> select = new AssociationSelect<ProductModelEntity>(connection);
                select.from(productModelProperty);
                select.associate(productAssociation);
                select.select(productProperty.Fields());
                select.select(productModelProperty.Fields());
                select.select(productCategoryProperty.Fields());
                select.setCriteria(c);

                List<ProductModelEntity> products = select.queryAsEntity();
                Assert.AreEqual(1, products.Count);
            }
            finally
            {
                connection.Close();
            }

        }
        [Test]
        public void selectTest6()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            productCategoryProperty.Catalog = "sampledb";

            ProductModelProperty productModelProperty = new ProductModelProperty();
            productModelProperty.Catalog = "advw";

            ProductProperty productProperty = new ProductProperty();
            productProperty.Catalog = "advw";

            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            ExpressionFactory expr = connection.getExpressionFactory();
            try
            {
                connection.Open();
                SelectCommandBuilder builder = new SelectCommandBuilder(connection);
                builder.from(productProperty)
                .joinLeft(productModelProperty, expr.relation(productProperty.productModelID, productModelProperty.productModelID))
                .joinLeft(productCategoryProperty, expr.relation(productProperty.productCategoryID, productCategoryProperty.productCategoryID))
                .select(productProperty.Fields())
                .select(productModelProperty.Fields())
                .select(productCategoryProperty.Fields())
                .orderBy(productProperty.productCategoryID)
                .orderBy(productProperty.productModelID)
                .orderBy(productProperty.productID);

                Command command = builder.getCommand();
                Assert.AreEqual("SELECT Product.ProductID AS Product__ProductID,Product.ProductNumber AS Product__ProductNumber,Product.Color AS Product__Color,Product.StandardCost AS Product__StandardCost,Product.ListPrice AS Product__ListPrice,Product.Size AS Product__Size,Product.Weight AS Product__Weight,Product.ProductCategoryID AS Product__ProductCategoryID,Product.ProductModelID AS Product__ProductModelID,Product.SellStartDate AS Product__SellStartDate,Product.SellEndDate AS Product__SellEndDate,Product.DiscontinuedDate AS Product__DiscontinuedDate,Product.ThumbnailPhotoFileName AS Product__ThumbnailPhotoFileName,Product.ModifiedDate AS Product__ModifiedDate,ProductModel.ProductModelID AS ProductModel__ProductModelID,ProductModel.ModifiedDate AS ProductModel__ModifiedDate,ProductCategory.ProductCategoryID AS ProductCategory__ProductCategoryID,ProductCategory.ParentProductCategoryID AS ProductCategory__ParentProductCategoryID,ProductCategory.ModifiedDate AS ProductCategory__ModifiedDate FROM advw.SalesLT.Product LEFT JOIN advw.SalesLT.ProductModel ON Product.ProductModelID = ProductModel.ProductModelID LEFT JOIN sampledb.SalesLT.ProductCategory ON Product.ProductCategoryID = ProductCategory.ProductCategoryID ORDER BY Product.ProductCategoryID ASC,Product.ProductModelID ASC,Product.ProductID ASC", command.Text);

            }
            finally
            {
                connection.Close();
            }
        }
        [Test]
        public void selectTest7()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            productCategoryProperty.Catalog = "sampledb";

            ProductModelProperty productModelProperty = new ProductModelProperty();
            productModelProperty.Catalog = "advw";

            ProductProperty productProperty = new ProductProperty();
            productProperty.Catalog = "advw";

            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            connection.QuotedIdentifier = true;
            ExpressionFactory expr = connection.getExpressionFactory();
            try
            {
                connection.Open();
                SelectCommandBuilder builder = new SelectCommandBuilder(connection);
                builder.from(productProperty)
                .joinLeft(productModelProperty, expr.relation(productProperty.productModelID, productModelProperty.productModelID))
                .joinLeft(productCategoryProperty, expr.relation(productProperty.productCategoryID, productCategoryProperty.productCategoryID))
                .select(productProperty.Fields())
                .select(productModelProperty.Fields())
                .select(productCategoryProperty.Fields())
                .orderBy(productProperty.productCategoryID)
                .orderBy(productProperty.productModelID)
                .orderBy(productProperty.productID);

                Command command = builder.getCommand();
                Assert.AreEqual(@"SELECT ""Product"".""ProductID"" AS ""Product__ProductID"",""Product"".""ProductNumber"" AS ""Product__ProductNumber"",""Product"".""Color"" AS ""Product__Color"",""Product"".""StandardCost"" AS ""Product__StandardCost"",""Product"".""ListPrice"" AS ""Product__ListPrice"",""Product"".""Size"" AS ""Product__Size"",""Product"".""Weight"" AS ""Product__Weight"",""Product"".""ProductCategoryID"" AS ""Product__ProductCategoryID"",""Product"".""ProductModelID"" AS ""Product__ProductModelID"",""Product"".""SellStartDate"" AS ""Product__SellStartDate"",""Product"".""SellEndDate"" AS ""Product__SellEndDate"",""Product"".""DiscontinuedDate"" AS ""Product__DiscontinuedDate"",""Product"".""ThumbnailPhotoFileName"" AS ""Product__ThumbnailPhotoFileName"",""Product"".""ModifiedDate"" AS ""Product__ModifiedDate"",""ProductModel"".""ProductModelID"" AS ""ProductModel__ProductModelID"",""ProductModel"".""ModifiedDate"" AS ""ProductModel__ModifiedDate"",""ProductCategory"".""ProductCategoryID"" AS ""ProductCategory__ProductCategoryID"",""ProductCategory"".""ParentProductCategoryID"" AS ""ProductCategory__ParentProductCategoryID"",""ProductCategory"".""ModifiedDate"" AS ""ProductCategory__ModifiedDate"" FROM ""advw"".""SalesLT"".""Product"" LEFT JOIN ""advw"".""SalesLT"".""ProductModel"" ON ""Product"".""ProductModelID"" = ""ProductModel"".""ProductModelID"" LEFT JOIN ""sampledb"".""SalesLT"".""ProductCategory"" ON ""Product"".""ProductCategoryID"" = ""ProductCategory"".""ProductCategoryID"" ORDER BY ""Product"".""ProductCategoryID"" ASC,""Product"".""ProductModelID"" ASC,""Product"".""ProductID"" ASC", command.Text);

            }
            finally
            {
                connection.Close();
            }
        }
        [Test]
        public void selectTest8()
        {
            ProductCategoryProperty productCategoryProperty = new ProductCategoryProperty();
            ProductModelProperty productModelProperty = new ProductModelProperty();
            ProductProperty productProperty = new ProductProperty();
            Connection connection = ConnectionFactory.GetConnectionByName("adventureWorks");
            try
            {
                connection.Open();
                //A
                Association productAssociation = new Association("products", Association.Multiplicity.TO_MANY, productProperty,
                    new RelationCondition(productModelProperty.productModelID, productProperty.productModelID)
                );
                productAssociation.add(new Association("category", Association.Multiplicity.TO_ONE, productCategoryProperty,
                    new RelationCondition(productProperty.productCategoryID, productCategoryProperty.productCategoryID)
                    )
                );

                ExpressionFactory expr = connection.getExpressionFactory();
                //
                CFW.Database.Criteria c = new CFW.Database.Criteria();
                c.where(expr.columnValue(productModelProperty.productModelID, new int[] { 1, 10 }, "BETWEEN"))
                    .orderBy(productProperty.productModelID)
                    .orderBy(productProperty.productID)
                    .orderBy(productProperty.productCategoryID);
                //A^ZNg
                AssociationSelect<ProductModelEntity> select = new AssociationSelect<ProductModelEntity>(connection);
                select.from(productModelProperty);
                select.associate(productAssociation);
                select.select(productProperty.Fields());
                select.select(productModelProperty.Fields());
                select.select(productCategoryProperty.Fields());
                select.setCriteria(c);

                List<ProductModelEntity> products = select.queryAsEntity();
                Assert.AreEqual(10, products.Count);
            }
            finally
            {
                connection.Close();
            }

        }
    }
}
