using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ProductDescriptionɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class ProductDescriptionTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[ProductDescriptionID]</summary>
        public FieldProperty productDescriptionID;
        ///<summary>[Description]</summary>
        public FieldProperty description;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public ProductDescriptionTableProperty()
        {
            this.EntityName = "ProductDescription";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            productDescriptionID = FieldProperty.NewInstance("int identity", "ProductDescription", "ProductDescriptionID","[ProductDescriptionID]", 4, 10, 0, false, 0,false);
            description = FieldProperty.NewInstance("nvarchar", "ProductDescription", "Description","[Description]", 800, 400, 0, false, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "ProductDescription", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.productDescriptionID;
            yield return this.description;
            yield return this.modifiedDate;
            
        }
                
    }
}