using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table CustomerɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class CustomerTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[CustomerID]</summary>
        public FieldProperty customerID;
        ///<summary>[Title]</summary>
        public FieldProperty title;
        ///<summary>[Suffix]</summary>
        public FieldProperty suffix;
        ///<summary>[CompanyName]</summary>
        public FieldProperty companyName;
        ///<summary>[SalesPerson]</summary>
        public FieldProperty salesPerson;
        ///<summary>[EmailAddress]</summary>
        public FieldProperty emailAddress;
        ///<summary>[PasswordHash]</summary>
        public FieldProperty passwordHash;
        ///<summary>[PasswordSalt]</summary>
        public FieldProperty passwordSalt;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public CustomerTableProperty()
        {
            this.EntityName = "Customer";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            customerID = FieldProperty.NewInstance("int identity", "Customer", "CustomerID","[CustomerID]", 4, 10, 0, false, 0,false);
            title = FieldProperty.NewInstance("nvarchar", "Customer", "Title","[Title]", 16, 8, 0, true, "",false);
            suffix = FieldProperty.NewInstance("nvarchar", "Customer", "Suffix","[Suffix]", 20, 10, 0, true, "",false);
            companyName = FieldProperty.NewInstance("nvarchar", "Customer", "CompanyName","[CompanyName]", 256, 128, 0, true, "",false);
            salesPerson = FieldProperty.NewInstance("nvarchar", "Customer", "SalesPerson","[SalesPerson]", 512, 256, 0, true, "",false);
            emailAddress = FieldProperty.NewInstance("nvarchar", "Customer", "EmailAddress","[EmailAddress]", 100, 50, 0, true, "",false);
            passwordHash = FieldProperty.NewInstance("varchar", "Customer", "PasswordHash","[PasswordHash]", 128, 128, 0, false, "",false);
            passwordSalt = FieldProperty.NewInstance("varchar", "Customer", "PasswordSalt","[PasswordSalt]", 10, 10, 0, false, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "Customer", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.customerID;
            yield return this.title;
            yield return this.suffix;
            yield return this.companyName;
            yield return this.salesPerson;
            yield return this.emailAddress;
            yield return this.passwordHash;
            yield return this.passwordSalt;
            yield return this.modifiedDate;
            
        }
                
    }
}