using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table BuildVersionɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class BuildVersionTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>Version number of the database in 9.yy.mm.dd.00 format.</summary>
        public FieldProperty databaseVersion;
        ///<summary>Date and time the record was last updated.</summary>
        public FieldProperty versionDate;
        ///<summary>Date and time the record was last updated.</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public BuildVersionTableProperty()
        {
            this.EntityName = "BuildVersion";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            databaseVersion = FieldProperty.NewInstance("nvarchar", "BuildVersion", "Database Version","Version number of the database in 9.yy.mm.dd.00 format.", 50, 25, 0, false, "",false);
            versionDate = FieldProperty.NewInstance("datetime", "BuildVersion", "VersionDate","Date and time the record was last updated.", 16, 23, 3, false, null,false);
            modifiedDate = FieldProperty.NewInstance("datetime", "BuildVersion", "ModifiedDate","Date and time the record was last updated.", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.databaseVersion;
            yield return this.versionDate;
            yield return this.modifiedDate;
            
        }
                
    }
}