using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table SalesOrderDetail Field`
    /// </summary>
    public class SalesOrderDetailTableFormAdapter : CFW.Forms.FormAdapter
	{
		private SalesOrderDetailTableRow theEntity;

		///<summary>[SalesOrderID]</summary>
		public FormAdapterElement salesOrderID;
		///<summary>[SalesOrderDetailID]</summary>
		public FormAdapterElement salesOrderDetailID;
		///<summary>[OrderQty]</summary>
		public FormAdapterElement orderQty;
		///<summary>[ProductID]</summary>
		public FormAdapterElement productID;
		///<summary>[UnitPrice]</summary>
		public FormAdapterElement unitPrice;
		///<summary>[UnitPriceDiscount]</summary>
		public FormAdapterElement unitPriceDiscount;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.salesOrderID != null) this.salesOrderID.Render();
			if(this.salesOrderDetailID != null) this.salesOrderDetailID.Render();
			if(this.orderQty != null) this.orderQty.Render();
			if(this.productID != null) this.productID.Render();
			if(this.unitPrice != null) this.unitPrice.Render();
			if(this.unitPriceDiscount != null) this.unitPriceDiscount.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (SalesOrderDetailTableRow)entity;
			if(this.salesOrderID != null) this.salesOrderID.SetValue(this.theEntity.salesOrderID);
			if(this.salesOrderDetailID != null) this.salesOrderDetailID.SetValue(this.theEntity.salesOrderDetailID);
			if(this.orderQty != null) this.orderQty.SetValue(this.theEntity.orderQty);
			if(this.productID != null) this.productID.SetValue(this.theEntity.productID);
			if(this.unitPrice != null) this.unitPrice.SetValue(this.theEntity.unitPrice);
			if(this.unitPriceDiscount != null) this.unitPriceDiscount.SetValue(this.theEntity.unitPriceDiscount);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.salesOrderID != null) this.theEntity.salesOrderID = NumberUtil.Value<Int32>(this.salesOrderID.GetValue());
			if(this.salesOrderDetailID != null) this.theEntity.salesOrderDetailID = NumberUtil.Value<Int32>(this.salesOrderDetailID.GetValue());
			if(this.orderQty != null) this.theEntity.orderQty = NumberUtil.Value<Int16>(this.orderQty.GetValue());
			if(this.productID != null) this.theEntity.productID = NumberUtil.Value<Int32>(this.productID.GetValue());
			if(this.unitPrice != null) this.theEntity.unitPrice = NumberUtil.Value<Decimal>(this.unitPrice.GetValue());
			if(this.unitPriceDiscount != null) this.theEntity.unitPriceDiscount = NumberUtil.Value<Decimal>(this.unitPriceDiscount.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.salesOrderID != null) this.salesOrderID.UpdateField();
			if(this.salesOrderDetailID != null) this.salesOrderDetailID.UpdateField();
			if(this.orderQty != null) this.orderQty.UpdateField();
			if(this.productID != null) this.productID.UpdateField();
			if(this.unitPrice != null) this.unitPrice.UpdateField();
			if(this.unitPriceDiscount != null) this.unitPriceDiscount.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.salesOrderID != null){
			    if(!this.salesOrderID.Validate()){
				    valid = false;
				    this.messages.Add(this.salesOrderID.ErrorMessage);
			    }
			}
			
			if(this.salesOrderDetailID != null){
			    if(!this.salesOrderDetailID.Validate()){
				    valid = false;
				    this.messages.Add(this.salesOrderDetailID.ErrorMessage);
			    }
			}
			
			if(this.orderQty != null){
			    if(!this.orderQty.Validate()){
				    valid = false;
				    this.messages.Add(this.orderQty.ErrorMessage);
			    }
			}
			
			if(this.productID != null){
			    if(!this.productID.Validate()){
				    valid = false;
				    this.messages.Add(this.productID.ErrorMessage);
			    }
			}
			
			if(this.unitPrice != null){
			    if(!this.unitPrice.Validate()){
				    valid = false;
				    this.messages.Add(this.unitPrice.ErrorMessage);
			    }
			}
			
			if(this.unitPriceDiscount != null){
			    if(!this.unitPriceDiscount.Validate()){
				    valid = false;
				    this.messages.Add(this.unitPriceDiscount.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private SalesOrderDetailFormAdapter formAdapter;
    //     private SalesOrderDetailProperty property;
    //     private SalesOrderDetailEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new SalesOrderDetailFormAdapter();

	
    formAdapter.salesOrderID= new TextBoxAdapterElement(
        salesOrderID,
        new CFW.Forms.Filters.StringFilter(property.salesOrderID),
        CFW.Validators.FieldValidator.GetInstance(property.salesOrderID)
    );
	
    formAdapter.salesOrderDetailID= new TextBoxAdapterElement(
        salesOrderDetailID,
        new CFW.Forms.Filters.StringFilter(property.salesOrderDetailID),
        CFW.Validators.FieldValidator.GetInstance(property.salesOrderDetailID)
    );
	
    formAdapter.orderQty= new TextBoxAdapterElement(
        orderQty,
        new CFW.Forms.Filters.StringFilter(property.orderQty),
        CFW.Validators.FieldValidator.GetInstance(property.orderQty)
    );
	
    formAdapter.productID= new TextBoxAdapterElement(
        productID,
        new CFW.Forms.Filters.StringFilter(property.productID),
        CFW.Validators.FieldValidator.GetInstance(property.productID)
    );
	
    formAdapter.unitPrice= new TextBoxAdapterElement(
        unitPrice,
        new CFW.Forms.Filters.StringFilter(property.unitPrice),
        CFW.Validators.FieldValidator.GetInstance(property.unitPrice)
    );
	
    formAdapter.unitPriceDiscount= new TextBoxAdapterElement(
        unitPriceDiscount,
        new CFW.Forms.Filters.StringFilter(property.unitPriceDiscount),
        CFW.Validators.FieldValidator.GetInstance(property.unitPriceDiscount)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}