using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table ProductDescription Field`
    /// </summary>
    public class ProductDescriptionTableFormAdapter : CFW.Forms.FormAdapter
	{
		private ProductDescriptionTableRow theEntity;

		///<summary>[ProductDescriptionID]</summary>
		public FormAdapterElement productDescriptionID;
		///<summary>[Description]</summary>
		public FormAdapterElement description;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.productDescriptionID != null) this.productDescriptionID.Render();
			if(this.description != null) this.description.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (ProductDescriptionTableRow)entity;
			if(this.productDescriptionID != null) this.productDescriptionID.SetValue(this.theEntity.productDescriptionID);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.productDescriptionID != null) this.theEntity.productDescriptionID = NumberUtil.Value<Int32>(this.productDescriptionID.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.productDescriptionID != null) this.productDescriptionID.UpdateField();
			if(this.description != null) this.description.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.productDescriptionID != null){
			    if(!this.productDescriptionID.Validate()){
				    valid = false;
				    this.messages.Add(this.productDescriptionID.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private ProductDescriptionFormAdapter formAdapter;
    //     private ProductDescriptionProperty property;
    //     private ProductDescriptionEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new ProductDescriptionFormAdapter();

	
    formAdapter.productDescriptionID= new TextBoxAdapterElement(
        productDescriptionID,
        new CFW.Forms.Filters.StringFilter(property.productDescriptionID),
        CFW.Validators.FieldValidator.GetInstance(property.productDescriptionID)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}