using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table Customer Field`
    /// </summary>
    public class CustomerTableFormAdapter : CFW.Forms.FormAdapter
	{
		private CustomerTableRow theEntity;

		///<summary>[CustomerID]</summary>
		public FormAdapterElement customerID;
		///<summary>[Title]</summary>
		public FormAdapterElement title;
		///<summary>[Suffix]</summary>
		public FormAdapterElement suffix;
		///<summary>[CompanyName]</summary>
		public FormAdapterElement companyName;
		///<summary>[SalesPerson]</summary>
		public FormAdapterElement salesPerson;
		///<summary>[EmailAddress]</summary>
		public FormAdapterElement emailAddress;
		///<summary>[PasswordHash]</summary>
		public FormAdapterElement passwordHash;
		///<summary>[PasswordSalt]</summary>
		public FormAdapterElement passwordSalt;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.customerID != null) this.customerID.Render();
			if(this.title != null) this.title.Render();
			if(this.suffix != null) this.suffix.Render();
			if(this.companyName != null) this.companyName.Render();
			if(this.salesPerson != null) this.salesPerson.Render();
			if(this.emailAddress != null) this.emailAddress.Render();
			if(this.passwordHash != null) this.passwordHash.Render();
			if(this.passwordSalt != null) this.passwordSalt.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (CustomerTableRow)entity;
			if(this.customerID != null) this.customerID.SetValue(this.theEntity.customerID);
			if(this.title != null) this.title.SetValue(this.theEntity.title);
			if(this.suffix != null) this.suffix.SetValue(this.theEntity.suffix);
			if(this.companyName != null) this.companyName.SetValue(this.theEntity.companyName);
			if(this.salesPerson != null) this.salesPerson.SetValue(this.theEntity.salesPerson);
			if(this.emailAddress != null) this.emailAddress.SetValue(this.theEntity.emailAddress);
			if(this.passwordHash != null) this.passwordHash.SetValue(this.theEntity.passwordHash);
			if(this.passwordSalt != null) this.passwordSalt.SetValue(this.theEntity.passwordSalt);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.customerID != null) this.theEntity.customerID = NumberUtil.Value<Int32>(this.customerID.GetValue());
			if(this.title != null) this.theEntity.title = StringUtil.StringValue(this.title.GetValue());
			if(this.suffix != null) this.theEntity.suffix = StringUtil.StringValue(this.suffix.GetValue());
			if(this.companyName != null) this.theEntity.companyName = StringUtil.StringValue(this.companyName.GetValue());
			if(this.salesPerson != null) this.theEntity.salesPerson = StringUtil.StringValue(this.salesPerson.GetValue());
			if(this.emailAddress != null) this.theEntity.emailAddress = StringUtil.StringValue(this.emailAddress.GetValue());
			if(this.passwordHash != null) this.theEntity.passwordHash = StringUtil.StringValue(this.passwordHash.GetValue());
			if(this.passwordSalt != null) this.theEntity.passwordSalt = StringUtil.StringValue(this.passwordSalt.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.customerID != null) this.customerID.UpdateField();
			if(this.title != null) this.title.UpdateField();
			if(this.suffix != null) this.suffix.UpdateField();
			if(this.companyName != null) this.companyName.UpdateField();
			if(this.salesPerson != null) this.salesPerson.UpdateField();
			if(this.emailAddress != null) this.emailAddress.UpdateField();
			if(this.passwordHash != null) this.passwordHash.UpdateField();
			if(this.passwordSalt != null) this.passwordSalt.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.customerID != null){
			    if(!this.customerID.Validate()){
				    valid = false;
				    this.messages.Add(this.customerID.ErrorMessage);
			    }
			}
			
			if(this.title != null){
			    if(!this.title.Validate()){
				    valid = false;
				    this.messages.Add(this.title.ErrorMessage);
			    }
			}
			
			if(this.suffix != null){
			    if(!this.suffix.Validate()){
				    valid = false;
				    this.messages.Add(this.suffix.ErrorMessage);
			    }
			}
			
			if(this.companyName != null){
			    if(!this.companyName.Validate()){
				    valid = false;
				    this.messages.Add(this.companyName.ErrorMessage);
			    }
			}
			
			if(this.salesPerson != null){
			    if(!this.salesPerson.Validate()){
				    valid = false;
				    this.messages.Add(this.salesPerson.ErrorMessage);
			    }
			}
			
			if(this.emailAddress != null){
			    if(!this.emailAddress.Validate()){
				    valid = false;
				    this.messages.Add(this.emailAddress.ErrorMessage);
			    }
			}
			
			if(this.passwordHash != null){
			    if(!this.passwordHash.Validate()){
				    valid = false;
				    this.messages.Add(this.passwordHash.ErrorMessage);
			    }
			}
			
			if(this.passwordSalt != null){
			    if(!this.passwordSalt.Validate()){
				    valid = false;
				    this.messages.Add(this.passwordSalt.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private CustomerFormAdapter formAdapter;
    //     private CustomerProperty property;
    //     private CustomerEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new CustomerFormAdapter();

	
    formAdapter.customerID= new TextBoxAdapterElement(
        customerID,
        new CFW.Forms.Filters.StringFilter(property.customerID),
        CFW.Validators.FieldValidator.GetInstance(property.customerID)
    );
	
    formAdapter.title= new TextBoxAdapterElement(
        title,
        new CFW.Forms.Filters.StringFilter(property.title),
        CFW.Validators.FieldValidator.GetInstance(property.title)
    );
	
    formAdapter.suffix= new TextBoxAdapterElement(
        suffix,
        new CFW.Forms.Filters.StringFilter(property.suffix),
        CFW.Validators.FieldValidator.GetInstance(property.suffix)
    );
	
    formAdapter.companyName= new TextBoxAdapterElement(
        companyName,
        new CFW.Forms.Filters.StringFilter(property.companyName),
        CFW.Validators.FieldValidator.GetInstance(property.companyName)
    );
	
    formAdapter.salesPerson= new TextBoxAdapterElement(
        salesPerson,
        new CFW.Forms.Filters.StringFilter(property.salesPerson),
        CFW.Validators.FieldValidator.GetInstance(property.salesPerson)
    );
	
    formAdapter.emailAddress= new TextBoxAdapterElement(
        emailAddress,
        new CFW.Forms.Filters.StringFilter(property.emailAddress),
        CFW.Validators.FieldValidator.GetInstance(property.emailAddress)
    );
	
    formAdapter.passwordHash= new TextBoxAdapterElement(
        passwordHash,
        new CFW.Forms.Filters.StringFilter(property.passwordHash),
        CFW.Validators.FieldValidator.GetInstance(property.passwordHash)
    );
	
    formAdapter.passwordSalt= new TextBoxAdapterElement(
        passwordSalt,
        new CFW.Forms.Filters.StringFilter(property.passwordSalt),
        CFW.Validators.FieldValidator.GetInstance(property.passwordSalt)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}