using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table CustomerAddress Field`
    /// </summary>
    public class CustomerAddressTableFormAdapter : CFW.Forms.FormAdapter
	{
		private CustomerAddressTableRow theEntity;

		///<summary>[CustomerID]</summary>
		public FormAdapterElement customerID;
		///<summary>[AddressID]</summary>
		public FormAdapterElement addressID;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.customerID != null) this.customerID.Render();
			if(this.addressID != null) this.addressID.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (CustomerAddressTableRow)entity;
			if(this.customerID != null) this.customerID.SetValue(this.theEntity.customerID);
			if(this.addressID != null) this.addressID.SetValue(this.theEntity.addressID);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.customerID != null) this.theEntity.customerID = NumberUtil.Value<Int32>(this.customerID.GetValue());
			if(this.addressID != null) this.theEntity.addressID = NumberUtil.Value<Int32>(this.addressID.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.customerID != null) this.customerID.UpdateField();
			if(this.addressID != null) this.addressID.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.customerID != null){
			    if(!this.customerID.Validate()){
				    valid = false;
				    this.messages.Add(this.customerID.ErrorMessage);
			    }
			}
			
			if(this.addressID != null){
			    if(!this.addressID.Validate()){
				    valid = false;
				    this.messages.Add(this.addressID.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private CustomerAddressFormAdapter formAdapter;
    //     private CustomerAddressProperty property;
    //     private CustomerAddressEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new CustomerAddressFormAdapter();

	
    formAdapter.customerID= new TextBoxAdapterElement(
        customerID,
        new CFW.Forms.Filters.StringFilter(property.customerID),
        CFW.Validators.FieldValidator.GetInstance(property.customerID)
    );
	
    formAdapter.addressID= new TextBoxAdapterElement(
        addressID,
        new CFW.Forms.Filters.StringFilter(property.addressID),
        CFW.Validators.FieldValidator.GetInstance(property.addressID)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}