using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table BuildVersion Field`
    /// </summary>
    public class BuildVersionTableFormAdapter : CFW.Forms.FormAdapter
	{
		private BuildVersionTableRow theEntity;

		///<summary>Version number of the database in 9.yy.mm.dd.00 format.</summary>
		public FormAdapterElement databaseVersion;
		///<summary>Date and time the record was last updated.</summary>
		public FormAdapterElement versionDate;
		///<summary>Date and time the record was last updated.</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.databaseVersion != null) this.databaseVersion.Render();
			if(this.versionDate != null) this.versionDate.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (BuildVersionTableRow)entity;
			if(this.databaseVersion != null) this.databaseVersion.SetValue(this.theEntity.databaseVersion);
			if(this.versionDate != null) this.versionDate.SetValue(this.theEntity.versionDate);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.databaseVersion != null) this.theEntity.databaseVersion = StringUtil.StringValue(this.databaseVersion.GetValue());
			if(this.versionDate != null) this.theEntity.versionDate = DateUtil.DateValue(this.versionDate.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.databaseVersion != null) this.databaseVersion.UpdateField();
			if(this.versionDate != null) this.versionDate.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.databaseVersion != null){
			    if(!this.databaseVersion.Validate()){
				    valid = false;
				    this.messages.Add(this.databaseVersion.ErrorMessage);
			    }
			}
			
			if(this.versionDate != null){
			    if(!this.versionDate.Validate()){
				    valid = false;
				    this.messages.Add(this.versionDate.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private BuildVersionFormAdapter formAdapter;
    //     private BuildVersionProperty property;
    //     private BuildVersionEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new BuildVersionFormAdapter();

	
    formAdapter.database Version= new TextBoxAdapterElement(
        database Version,
        new CFW.Forms.Filters.StringFilter(property.database Version),
        CFW.Validators.FieldValidator.GetInstance(property.database Version)
    );
	
    formAdapter.versionDate= new TextBoxAdapterElement(
        versionDate,
        new CFW.Forms.Filters.StringFilter(property.versionDate),
        CFW.Validators.FieldValidator.GetInstance(property.versionDate)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}