using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test
{
    [TestFixture]
    public class UtilTest
    {
        [NUnit.Framework.Test]
        public void ConcatArrayList()
        {
            ArrayList list1 = new ArrayList(new int[]{1,2,3,4,5});
            ArrayList list2 = new ArrayList(new int[] { 6,7,8,9,10 });

            ArrayList list3 = CFW.Util.Util.ConcatArrayList(list1, list2);
            Assert.AreEqual(5, list1.Count);
            Assert.AreEqual(5, list2.Count);
            Assert.AreEqual(10, list3.Count);

            Assert.AreEqual(1, list3[0]);
            Assert.AreEqual(2, list3[1]);
            Assert.AreEqual(3, list3[2]);
            Assert.AreEqual(4, list3[3]);
            Assert.AreEqual(5, list3[4]);
            Assert.AreEqual(6, list3[5]);
            Assert.AreEqual(7, list3[6]);
            Assert.AreEqual(8, list3[7]);
            Assert.AreEqual(9, list3[8]);
            Assert.AreEqual(10, list3[9]);
        }
        [NUnit.Framework.Test]
        public void ConcatList()
        {
            List<int> list1 = new List<int>(new int[] { 1, 2, 3, 4, 5 });
            List<int> list2 = new List<int>(new int[] { 6, 7, 8, 9, 10 });

            List<int> list3 = CFW.Util.Util.ConcatList(list1, list2);
            Assert.AreEqual(5, list1.Count);
            Assert.AreEqual(5, list2.Count);
            Assert.AreEqual(10, list3.Count);

            Assert.AreEqual(1, list3[0]);
            Assert.AreEqual(2, list3[1]);
            Assert.AreEqual(3, list3[2]);
            Assert.AreEqual(4, list3[3]);
            Assert.AreEqual(5, list3[4]);
            Assert.AreEqual(6, list3[5]);
            Assert.AreEqual(7, list3[6]);
            Assert.AreEqual(8, list3[7]);
            Assert.AreEqual(9, list3[8]);
            Assert.AreEqual(10, list3[9]);
        }
        [NUnit.Framework.Test]
        public void ConcatByteArray()
        {
            byte[] list1 = new byte[] { 1, 2, 3, 4, 5 };
            byte[] list2 = new byte[] { 6, 7, 8, 9, 10 };

            byte[] list3 = CFW.Util.Util.ConcatByteArray(list1, list2);
            Assert.AreEqual(5, list1.Length);
            Assert.AreEqual(5, list2.Length);
            Assert.AreEqual(10, list3.Length);

            Assert.AreEqual(1, list3[0]);
            Assert.AreEqual(2, list3[1]);
            Assert.AreEqual(3, list3[2]);
            Assert.AreEqual(4, list3[3]);
            Assert.AreEqual(5, list3[4]);
            Assert.AreEqual(6, list3[5]);
            Assert.AreEqual(7, list3[6]);
            Assert.AreEqual(8, list3[7]);
            Assert.AreEqual(9, list3[8]);
            Assert.AreEqual(10, list3[9]);
        }
    }
}
