using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.Util;

namespace CFW.Common.Test
{
    [TestFixture]

    public class TimeTest
    {
        [NUnit.Framework.Test(Description = "\z")]
        public void Time()
        {
            CFW.Util.Time t = new CFW.Util.Time();
            Assert.AreEqual(0, t.Day);
            Assert.AreEqual(0, t.Hour);
            Assert.AreEqual(0, t.Minute);

            t = new CFW.Util.Time(1234);
            Assert.AreEqual(0, t.Day);
            Assert.AreEqual(12, t.Hour);
            Assert.AreEqual(34, t.Minute);

            t = new CFW.Util.Time(12,34);
            Assert.AreEqual(0, t.Day);
            Assert.AreEqual(12, t.Hour);
            Assert.AreEqual(34, t.Minute);

            t = new CFW.Util.Time("1234");
            Assert.AreEqual(0, t.Day);
            Assert.AreEqual(12, t.Hour);
            Assert.AreEqual(34, t.Minute);

            t = new CFW.Util.Time("1:23");
            Assert.AreEqual(0, t.Day);
            Assert.AreEqual(1, t.Hour);
            Assert.AreEqual(23, t.Minute);
        }
        [NUnit.Framework.Test(Description = "ԉZ")]
        public void AddHours()
        {
            Time t = new CFW.Util.Time(1234);
            Time t2 = t.AddHours(10);
            Assert.AreEqual(22, t2.Hour);

            t = new CFW.Util.Time(1234);
            t2 = t.AddHours(22);
            Assert.AreEqual(1, t2.Day);
            Assert.AreEqual(10, t2.Hour);
        
        }
        [NUnit.Framework.Test(Description = "ԉZ")]
        public void AddHours2()
        {
            Time t = new CFW.Util.Time(1234);
            Time t2 = CFW.Util.Time.AddHours(t,10);
            Assert.AreEqual(22, t2.Hour);

            t = new CFW.Util.Time(1234);
            t2 = CFW.Util.Time.AddHours(t,22);
            Assert.AreEqual(1, t2.Day);
            Assert.AreEqual(10, t2.Hour);

        }
        [NUnit.Framework.Test(Description = "Z")]
        public void AddMinutes()
        {
            Time t = new CFW.Util.Time(1234);
            Time t2 = t.AddMinutes(20);
            Assert.AreEqual(12, t2.Hour);
            Assert.AreEqual(54, t2.Minute);

            t = new CFW.Util.Time(1234);
            t2 = t.AddMinutes(301);
            Assert.AreEqual(17, t2.Hour);
            Assert.AreEqual(35, t2.Minute);

        }
        [NUnit.Framework.Test(Description = "")]
        public void Format()
        {
            Time t = new CFW.Util.Time(1234);
            string result = t.Format();
            Assert.AreEqual("12:34", result);

           t = new CFW.Util.Time(456);
           result = t.Format();
            Assert.AreEqual("04:56", result);
        }
        [NUnit.Framework.Test(Description = "{ꏑ")]
        public void FormatJP()
        {
            Time t = new CFW.Util.Time(1234);
            string result = t.FormatJP();
            Assert.AreEqual("1234", result);

            t = new CFW.Util.Time(456);
            result = t.FormatJP();
            Assert.AreEqual("0456", result);
        }
    }
}
