using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Log
{
    [NUnit.Framework.TestFixture]
    public class LoggerTest
    {

        [NUnit.Framework.Test]
        public void Info()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Info(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void Warn()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Warn(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void Err()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Error(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void Debug()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void Fatal()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Fatal(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void UserLog()
        {
            //login
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            Assert.IsNotNull(provider);

            provider.Authenticate("nulluser", "nulluser");

            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("userLog", "test");
            logger.Info(System.Reflection.MethodBase.GetCurrentMethod().Name, "testaaaaa");
            logger.Error(System.Reflection.MethodBase.GetCurrentMethod().Name, "testaaaaa");
            logger.Warn(System.Reflection.MethodBase.GetCurrentMethod().Name, "testaaaaa");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "testaaaaa");
            logger.Fatal(System.Reflection.MethodBase.GetCurrentMethod().Name, "testaaaaa");

            provider.Logout();

        }
        [NUnit.Framework.Test]
        public void UserLog2()
        {
            //login
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            Assert.IsNotNull(provider);

            provider.Authenticate("nulluser", "nulluser");

            CFW.Log.LogCapture capture = CFW.Log.LoggerFactory.getCapture("userLog");
            capture.log(CFW.Log.LogLevel.INFO, System.Reflection.MethodBase.GetCurrentMethod(), "testaaaaa");
            capture.log(CFW.Log.LogLevel.ERROR, System.Reflection.MethodBase.GetCurrentMethod(), "testaaaaa");
            capture.log(CFW.Log.LogLevel.WARN, System.Reflection.MethodBase.GetCurrentMethod(), "testaaaaa");
            capture.log(CFW.Log.LogLevel.DEBUG, System.Reflection.MethodBase.GetCurrentMethod(), "testaaaaa");
            capture.log(CFW.Log.LogLevel.FATAL, System.Reflection.MethodBase.GetCurrentMethod(), "testaaaaa");
            capture.flush();

            provider.Logout();

        }
        #region LogServiceTest
        [NUnit.Framework.Test]
        public void LogServiceInfo()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("logService", "test");
            logger.Info(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void LogServiceWarn()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("logService", "test");
            logger.Warn(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void LogServiceErr()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("logService", "test");
            logger.Error(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void LogServiceDebug()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("logService", "test");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void LogServiceFatal()
        {
            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("logService", "test");
            logger.Fatal(System.Reflection.MethodBase.GetCurrentMethod().Name, "test");
        }
        [NUnit.Framework.Test]
        public void capture()
        {
            CFW.Log.LogCapture capture = CFW.Log.LoggerFactory.getCapture("logService");
            capture.log(CFW.Log.LogLevel.DEBUG, System.Reflection.MethodBase.GetCurrentMethod(), "this is capture test");
            capture.log(CFW.Log.LogLevel.ERROR, System.Reflection.MethodBase.GetCurrentMethod(), "this is capture test");
            capture.log(CFW.Log.LogLevel.FATAL, System.Reflection.MethodBase.GetCurrentMethod(), "this is capture test");
            capture.log(CFW.Log.LogLevel.INFO, System.Reflection.MethodBase.GetCurrentMethod(), "this is capture test");
            capture.log(CFW.Log.LogLevel.WARN, System.Reflection.MethodBase.GetCurrentMethod(), "this is capture test");
            capture.flush();
        }
        #endregion
    }
}
