using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW;
using CFW.Forms;

namespace CFW.Common.Test.Forms
{
    [TestFixture]
    public class InitialParameterTest
    {
        [NUnit.Framework.Test(Description="JSON͂ăp[^IuWFNgɕϊeXg")]
        public void fromJSONString()
        {
            string parameterString = @"{""parameter1"" : ""p001"",""parameter2"" : 101, ""parameter3"" : ""2010/12/31""}";
            InitialParameters parameters = new InitialParameters();
            parameters.fromJSONString(parameterString);

            Assert.IsTrue(parameters.nameExists("parameter1"));
            Assert.IsTrue(parameters.nameExists("parameter2"));
            Assert.IsTrue(parameters.nameExists("parameter3"));
            Assert.IsFalse(parameters.nameExists("parameter4"));

            Assert.AreEqual("p001",parameters.get("parameter1"));
            Assert.AreEqual("p001", parameters["parameter1"]); //indexerł̃ANZXB֗H

            Assert.AreEqual(101, parameters["parameter2"]);
            Assert.AreEqual("2010/12/31", parameters["parameter3"]);
        }
        [NUnit.Framework.Test(Description = "󕶎neXg")]
        public void fromJSONStringEmpty()
        {
            string parameterString = @"";
            InitialParameters parameters = new InitialParameters();
            parameters.fromJSONString(parameterString);

            Assert.IsFalse(parameters.nameExists("parameter1"));
            Assert.IsFalse(parameters.nameExists("parameter2"));
            Assert.IsFalse(parameters.nameExists("parameter3"));
            Assert.IsFalse(parameters.nameExists("parameter4"));

        }
        [NUnit.Framework.Test(Description = "nullneXg")]
        public void fromJSONStringNull()
        {
            string parameterString = null;
            InitialParameters parameters = new InitialParameters();
            parameters.fromJSONString(parameterString);

            Assert.IsFalse(parameters.nameExists("parameter1"));
            Assert.IsFalse(parameters.nameExists("parameter2"));
            Assert.IsFalse(parameters.nameExists("parameter3"));
            Assert.IsFalse(parameters.nameExists("parameter4"));

        }
        [NUnit.Framework.Test(Description = "܂ƂłȂneXgP")]
        public void fromJSONStringInvalid1()
        {
            string parameterString = @"{}";
            InitialParameters parameters = new InitialParameters();
            parameters.fromJSONString(parameterString);

            Assert.IsFalse(parameters.nameExists("parameter1"));
            Assert.IsFalse(parameters.nameExists("parameter2"));
            Assert.IsFalse(parameters.nameExists("parameter3"));
            Assert.IsFalse(parameters.nameExists("parameter4"));

        }
        [NUnit.Framework.Test(Description = "O𑗏op^[B")]
        [NUnit.Framework.ExpectedException]
        public void fromJSONStringException()
        {
            string parameterString = @"{""parameter1"":""p1"" ""parameter2"":""p1""}";
            InitialParameters parameters = new InitialParameters();
            parameters.fromJSONString(parameterString);

            Assert.IsFalse(parameters.nameExists("parameter1"));
            Assert.IsFalse(parameters.nameExists("parameter2"));
            Assert.IsFalse(parameters.nameExists("parameter3"));
            Assert.IsFalse(parameters.nameExists("parameter4"));

        }
    }
}
