using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Forms.Filters
{
    [TestFixture]
    public class StringFilterTest
    {
        [NUnit.Framework.Test]
        public void FilterString()
        {
            CFW.Forms.Filters.StringFilter filter = new CFW.Forms.Filters.StringFilter(10);

            string source = "abcdefghijklmn";
            object result = filter.FilterValue(source);
            Assert.AreEqual("abcdefghij",result);

            source = "abcdef";
            result = filter.FilterValue(source);
            Assert.AreEqual("abcdef", result);
        }
        [NUnit.Framework.Test]
        public void FilterString2()
        {
            CFW.Forms.Filters.StringFilter filter = new CFW.Forms.Filters.StringFilter(10,
                CFW.Util.StringUtil.NormalizeMode.ToNarrow | CFW.Util.StringUtil.NormalizeMode.ToUpper);

            string source = "abcdefghijklmn";
            object result = filter.FilterValue(source);
            Assert.AreEqual("ABCDEFGHIJ", result);

            source = "abcdef";
            result = filter.FilterValue(source);
            Assert.AreEqual("ABCDEF", result);

            source = "";
            result = filter.FilterValue(source);
            Assert.AreEqual("ABCDEFGHIJ", result);

            source = "";
            result = filter.FilterValue(source);
            Assert.AreEqual("", result);
        }
        [NUnit.Framework.Test]
        public void FilterString3()
        {
            CFW.Forms.Filters.StringFilter filter = new CFW.Forms.Filters.StringFilter(10,
                CFW.Util.StringUtil.NormalizeMode.ToAlpha | CFW.Util.StringUtil.NormalizeMode.ToLower | CFW.Util.StringUtil.NormalizeMode.ToNarrow);

            string source = "ABCDEFGHIJKLMN";
            object result = filter.FilterValue(source);
            Assert.AreEqual("abcdefghij", result);

            source = "ABCDEF";
            result = filter.FilterValue(source);
            Assert.AreEqual("abcdef", result);

            source = "`abcdefghijklm";
            result = filter.FilterValue(source);
            Assert.AreEqual("abcdefghij", result);

            source = "";
            result = filter.FilterValue(source);
            Assert.AreEqual("", result);
        }
        [NUnit.Framework.Test]
        public void FilterString4()
        {
            CFW.Forms.Filters.StringFilter filter = new CFW.Forms.Filters.StringFilter(10,
                CFW.Util.StringUtil.NormalizeMode.ToDigit | CFW.Util.StringUtil.NormalizeMode.ToNarrow);

            string source = "ABCDEFGHIJKLMN";
            object result = filter.FilterValue(source);
            Assert.AreEqual("", result);

            source = "ABC123456";
            result = filter.FilterValue(source);
            Assert.AreEqual("123456", result);

            source = "`abcdefghijklmPQRSTUVWXO";
            result = filter.FilterValue(source);
            Assert.AreEqual("1234567890", result);

            source = "00123";
            result = filter.FilterValue(source);
            Assert.AreEqual("00123", result);
        }
    }
}
