using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Forms.Filters
{
    [TestFixture]
    public class NumericFilterTest
    {
        [NUnit.Framework.Test]
        public void FilterString()
        {
            CFW.Forms.Filters.NumberFilter<int> filter = new CFW.Forms.Filters.NumberFilter<int>(10, 0, true);

            string source = "1234568790";
            object result = filter.FilterValue(source);
            Assert.IsInstanceOfType(typeof(int), result);
            Assert.AreEqual(1234568790, result);

            source = "123456879012";
            result = filter.FilterValue(source);
            Assert.IsInstanceOfType(typeof(string), result);
            Assert.AreEqual("3456879012", result);

            source = "123456879.345";
            result = filter.FilterValue(source);
            Assert.AreEqual(123456879, result);

            source = "12345.678";
            result = filter.FilterValue(source);
            Assert.AreEqual(12345, result);

            source = "12345";
            result = filter.FilterValue(source);
            Assert.AreEqual(12345, result);
        }
        [NUnit.Framework.Test]
        public void FilterString2()
        {
            CFW.Forms.Filters.NumberFilter<decimal> filter = new CFW.Forms.Filters.NumberFilter<decimal>(5, 2, true);

            string source = "1234568790";
            object result = filter.FilterValue(source);
            Assert.AreEqual(790, result);

            source = "123456879012";
            result = filter.FilterValue(source);
            Assert.AreEqual(12, result);

            source = "123456879012.345";
            result = filter.FilterValue(source);
            Assert.AreEqual(12.34, result);

            source = "12345.678";
            result = filter.FilterValue(source);
            Assert.AreEqual(345.67, result);

            source = "-12345";
            result = filter.FilterValue(source);
            Assert.AreEqual(-345, result);
        }
    }
}
