using System;
using System.Collections.Generic;
using System.Text;
using CFW.FieldProperties;
using NUnit.Framework;

namespace CFW.Common.Test.FieldProperties
{
    [NUnit.Framework.TestFixture]
    public class StringFieldPropertyTest
    {
        [NUnit.Framework.Test]
        public void createTest1()
        {
            FieldProperty p = FieldProperty.create("varchar");
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(8000, p.Length);
            Assert.AreEqual(4000, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest2()
        {
            FieldProperty p = FieldProperty.create("varchar", "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(8000, p.Length);
            Assert.AreEqual(4000, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create("varchar", 5);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(5, p.Length);
            Assert.AreEqual(5, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest4()
        {
            FieldProperty p = FieldProperty.create("varchar", 3, 2);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            //d
            Assert.AreEqual(0, p.Length);
            Assert.AreEqual(3, p.Precision);
            Assert.AreEqual(2, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest5()
        {
            //full spec
            FieldProperty p = FieldProperty.create("varchar", "table1", "column1", "1", 100, 50, 0, false, "a", true);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(100, p.Length);
            Assert.AreEqual(50, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual("a", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType1()
        {
            FieldProperty p = FieldProperty.create(typeof(string));
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(8000, p.Length);
            Assert.AreEqual(4000, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType2()
        {
            FieldProperty p = FieldProperty.create(typeof(string), "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(8000, p.Length);
            Assert.AreEqual(4000, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create(typeof(string), 5);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(10, p.Length);
            Assert.AreEqual(5, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType4()
        {
            //precision,scalew肵precision̂ݍ̗pB͍őlAŏlɊւ
            FieldProperty p = FieldProperty.create(typeof(string), 4, 2);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(0, p.Length);
            Assert.AreEqual(4, p.Precision);
            Assert.AreEqual(2, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual("", p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType5()
        {
            //full spec
            FieldProperty p = FieldProperty.create(typeof(string), "table1", "column1", "1", 100, 50, 0, false, 1, true);
            Assert.IsInstanceOfType(typeof(StringFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(string), p.FieldType);
            Assert.AreEqual(100, p.Length);
            Assert.AreEqual(50, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual("1", p.DefaultValue);

        }
    }
}
