using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
namespace CFW.Common.Test.ErrorHandler
{
    [NUnit.Framework.TestFixture]
    public class ErrorHandlerTest
    {
        [NUnit.Framework.Test]
        public void NullPointerExceptionTest()
        {
            try
            {
                NullPointerException ex = new NullPointerException();
                throw ex;
            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder handler = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                Assert.IsInstanceOfType(typeof(NullPointerExceptionMessageBuilder), handler);
                Assert.AreEqual("ʂ", handler.BuildMessage());
                Assert.AreEqual("ʂ\r\nKb", handler.BuildLogMessage());
                handler.WriteLog();
            }
        }
        [NUnit.Framework.Test]
        public void NotImplementExceptionTest()
        {
            try
            {
                System.NotImplementedException ex = new NotImplementedException("̃\bh͎ĂȂ");
                throw ex;
            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder handler = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                Assert.IsInstanceOfType(typeof(CFW.ErrorHandler.DefaultErrorMessageBuilder), handler);
                Assert.AreEqual("̃\bh͎ĂȂ", handler.BuildMessage());
                Assert.AreEqual("̃\bh͎ĂȂ", handler.BuildLogMessage());
                handler.WriteLog();
            }
        }
    }
    public class NullPointerExceptionMessageBuilder : CFW.ErrorHandler.ErrorMessageBuilder
    {
        public override string BuildMessage()
        {
            return this.mException.Message;
        }

        public override string BuildLogMessage()
        {
            return this.mException.Message + Environment.NewLine + "Kb";
        }
    }
    public class NullPointerException : Exception
    {
        public NullPointerException() : base("ʂ")
        {
        }
    }
}
