using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
namespace CFW.Common.Test.Acl
{
    [TestFixture]
    public class AclRuleTest
    {
        [NUnit.Framework.Test]
        public void IsAllowed()
        {
            CFW.Acl.AclRule rule = new CFW.Acl.AclRule();
            //ǂݎƍXVo郋[
            rule.privilege = CFW.Acl.AclPrivilege.Read | CFW.Acl.AclPrivilege.Update;

            bool result = rule.isAllowed(CFW.Acl.AclPrivilege.Read);
            Assert.IsTrue(result);

            result = rule.isAllowed(CFW.Acl.AclPrivilege.Update);
            Assert.IsTrue(result);

            result = rule.isAllowed(CFW.Acl.AclPrivilege.Create);
            Assert.IsFalse(result);

            result = rule.isAllowed(CFW.Acl.AclPrivilege.Delete);
            Assert.IsFalse(result);

            //[`FbN
            result = rule.isAllowed(CFW.Acl.AclPrivilege.Read | CFW.Acl.AclPrivilege.Update);
            Assert.IsTrue(result);

            result = rule.isAllowed(CFW.Acl.AclPrivilege.Create | CFW.Acl.AclPrivilege.Update);
            Assert.IsFalse(result);

            result = rule.isAllowed(CFW.Acl.AclPrivilege.Create | CFW.Acl.AclPrivilege.Delete);
            Assert.IsFalse(result);
        }

    }
}
