using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.CommandBuilder;
using CFW.Database.Expressions;

namespace Taskman2.SqlServer.Models 
{
    /// <summary>
    /// Tasks f`
    /// </summary>
    [Serializable()]
    public class TasksModel : DbModel<TasksEntity, TasksProperty>
    {
        Random rnd = new Random();

        /// <summary>
        /// default construct  
        /// </summary>
        public TasksModel()
            : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public TasksModel(Connection connection)
            : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public TasksModel(Connection connection, TasksProperty property)
            : base(connection, property)
        {
        }
        public int generateRandom()
        {
            try
            {
                this.connect("sqlserver");
                int startId = generateId();
                List<TasksEntity> tasks = new List<TasksEntity>();
                for (int i = 0; i < 100; i++)
                {
                    tasks.Add(generateRandomItem(startId + i));
                }
                this.save(tasks);

                return 100;

            }
            finally
            {
                this.disconnect();
            }
        }
        private TasksEntity generateRandomItem(int id)
        {
            try
            {
                this.connect("sqlserver");

                TasksEntity newTask = new TasksEntity();
                newTask.taskId = id;
                newTask.statusId = new int[] { 10, 20, 80, 99 }[rnd.Next(0, 3)];
                newTask.categoryId = rnd.Next(1, 6);
                newTask.priorityId = rnd.Next(1, 5);
                newTask.subject = "test task " + newTask.taskId.ToString();
                newTask.description = "description of test task " + newTask.taskId.ToString();
                newTask.IsNew = true;
                newTask.IsModified = true;

                return newTask;

            }
            finally
            {
                this.disconnect();
            }

        }
        private int generateId()
        {
            try
            {
                this.connect("sqlserver");

                SelectCommandBuilder builder = new SelectCommandBuilder(this.connection);
                builder.from("TASKS")
                    .select("ISNULL(MAX(TASK_ID),0) + 1", "newId");

                DataSet result = builder.getCommand().ExecuteQuery(this.connection);
                return NumberUtil.Value<int>(result.Tables[0].Rows[0][0]);

            }
            finally
            {
                this.disconnect();
            }
        }
        public DataSet findAll()
        {
            try
            {
                this.connect("sqlserver");

                TasksProperty tasksProperty = new TasksProperty();
                StatusesProperty statusesProperty = new StatusesProperty();
                PrioritiesProperty prioritiesProperty = new PrioritiesProperty();
                CategoriesProperty categoriesProperty = new CategoriesProperty();

                ExpressionFactory ef = connection.getExpressionFactory();

                SelectCommandBuilder builder = new SelectCommandBuilder(this.connection);
                builder.from(tasksProperty)
                    .joinLeft("STATUSES", ef.relation(tasksProperty.statusId, statusesProperty.statusId))
                    .joinLeft("PRIORITIES", ef.relation(tasksProperty.priorityId, prioritiesProperty.priorityId))
                    .joinLeft("CATEGORIES", ef.relation(tasksProperty.categoryId, categoriesProperty.categoryId))
                    .select(tasksProperty.Fields())
                    .select(statusesProperty.Fields())
                    .select(prioritiesProperty.Fields())
                    .select(categoriesProperty.Fields())
                    .where(ef.columnValue(statusesProperty.closed, NumberUtil.BoolToInt(false)))
                    .orderBy(tasksProperty.categoryId, "ASC")
                    .orderBy(tasksProperty.priorityId, "DESC");
                    

                DataSet result = builder.getCommand().ExecuteQuery(this.connection);
                return result;

            }
            finally
            {
                this.disconnect();
            }
        }
        public StatusesEntity getStatus(int taskId)
        {
            try
            {
                this.connect("sqlserver");

                Command command = new Command("Tasks_getStatus", CommandType.StoredProcedure);
                command.input(new Parameter("@taskId",taskId))
                    .output(new Parameter("@statusId",DbType.Int32))
                    .output(new Parameter("@statusName", DbType.String,null,100,0));
                    
                int result = command.ExecuteUpdate(this.connection);
                if (result == 0)
                {
                    return null;
                }
                StatusesEntity status = new StatusesEntity();
                status.statusId = NumberUtil.Value<int>( command.FindParameter("@statusId").ParameterValue );
                status.statusName = StringUtil.StringValue(command.FindParameter("@statusName").ParameterValue);
                return status;

            }
            finally
            {
                this.disconnect();
            }
        }
    }

}