using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.SqlServer.Models.Base
{
    /// <summary>
    /// table sample1ɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class Sample1TableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[id]</summary>
        public FieldProperty id;
        ///<summary>[short_field]</summary>
        public FieldProperty shortField;
        ///<summary>[date_field]</summary>
        public FieldProperty dateField;
        ///<summary>[timestamp_field]</summary>
        public FieldProperty timestampField;
        ///<summary>[string_field1]</summary>
        public FieldProperty stringField1;
        ///<summary>[string_field2]</summary>
        public FieldProperty stringField2;
        ///<summary>[string_field3]</summary>
        public FieldProperty stringField3;
        ///<summary>[number_field1]</summary>
        public FieldProperty numberField1;
        ///<summary>[number_field2]</summary>
        public FieldProperty numberField2;
        ///<summary>[number_field3]</summary>
        public FieldProperty numberField3;
        

        /// <summary>
        /// default construct
        /// </summary>
        public Sample1TableProperty()
        {
            this.EntityName = "sample1";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            id = FieldProperty.NewInstance("int", "sample1", "id","[id]", 4, 10, 0, false, 0,true);
            shortField = FieldProperty.NewInstance("smallint", "sample1", "short_field","[short_field]", 2, 5, 0, true, null,false);
            dateField = FieldProperty.NewInstance("datetime", "sample1", "date_field","[date_field]", 16, 23, 3, true, null,false);
            timestampField = FieldProperty.NewInstance("datetime", "sample1", "timestamp_field","[timestamp_field]", 16, 23, 3, false, null,false);
            stringField1 = FieldProperty.NewInstance("varchar", "sample1", "string_field1","[string_field1]", 100, 100, 0, true, "",false);
            stringField2 = FieldProperty.NewInstance("char", "sample1", "string_field2","[string_field2]", 10, 10, 0, true, "",false);
            stringField3 = FieldProperty.NewInstance("nvarchar", "sample1", "string_field3","[string_field3]", 200, 100, 0, true, "",false);
            numberField1 = FieldProperty.NewInstance("decimal", "sample1", "number_field1","[number_field1]", 20, 18, 0, true, null,false);
            numberField2 = FieldProperty.NewInstance("decimal", "sample1", "number_field2","[number_field2]", 12, 10, 0, true, null,false);
            numberField3 = FieldProperty.NewInstance("decimal", "sample1", "number_field3","[number_field3]", 12, 10, 2, true, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.id;
            yield return this.shortField;
            yield return this.dateField;
            yield return this.timestampField;
            yield return this.stringField1;
            yield return this.stringField2;
            yield return this.stringField3;
            yield return this.numberField1;
            yield return this.numberField2;
            yield return this.numberField3;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.id;
            
        }
                
    }
}